/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.aichatmoderation.scheduler;

import com.ssomar.aichatmoderation.scheduler.ScheduledTask;
import com.ssomar.aichatmoderation.scheduler.SchedulerHook;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BukkitSchedulerHook
implements SchedulerHook {
    private final Plugin plugin;

    public BukkitSchedulerHook(Plugin plugin) {
        this.plugin = plugin;
    }

    public BukkitRunnable toBukkitRunnable(final Runnable runnable) {
        return new BukkitRunnable(this){
            final /* synthetic */ BukkitSchedulerHook this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                runnable.run();
            }
        };
    }

    @Override
    public ScheduledTask runTask(Runnable runnable, long delay) {
        if (delay > 0L) {
            return new BukkitScheduledTask(this.toBukkitRunnable(runnable).runTaskLater(this.plugin, delay).getTaskId());
        }
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
            return new ScheduledTask(){

                @Override
                public void cancel() {
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }
            };
        }
        return new BukkitScheduledTask(this.toBukkitRunnable(runnable).runTask(this.plugin).getTaskId());
    }

    @Override
    public ScheduledTask runRepeatingTask(Runnable runnable, long initDelay, long period) {
        return new BukkitScheduledTask(this.toBukkitRunnable(runnable).runTaskTimer(this.plugin, initDelay, period).getTaskId());
    }

    @Override
    public ScheduledTask runAsyncTask(Runnable runnable, long delay) {
        if (delay > 0L) {
            return new BukkitScheduledTask(this.toBukkitRunnable(runnable).runTaskLaterAsynchronously(this.plugin, delay).getTaskId());
        }
        return new BukkitScheduledTask(this.toBukkitRunnable(runnable).runTaskAsynchronously(this.plugin).getTaskId());
    }

    @Override
    public ScheduledTask runAsyncRepeatingTask(Runnable runnable, long initDelay, long period) {
        return new BukkitScheduledTask(this.toBukkitRunnable(runnable).runTaskTimerAsynchronously(this.plugin, initDelay, period).getTaskId());
    }

    @Override
    public ScheduledTask runEntityTask(Runnable runnable, Runnable retired, Entity entity, long delay) {
        return this.runTask(runnable, delay);
    }

    @Override
    public ScheduledTask runEntityTaskAsap(Runnable runnable, Runnable retired, Entity entity) {
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
            return new ScheduledTask(){

                @Override
                public void cancel() {
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }
            };
        }
        return this.runTask(runnable, 0L);
    }

    @Override
    public ScheduledTask runLocationTask(Runnable runnable, Location location, long delay) {
        return this.runTask(runnable, delay);
    }

    @Override
    public ScheduledTask runLocationTaskAsap(Runnable runnable, Location location) {
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
            return new ScheduledTask(){

                @Override
                public void cancel() {
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }
            };
        }
        return this.runTask(runnable, 0L);
    }

    private static class BukkitScheduledTask
    implements ScheduledTask {
        private final int taskId;

        private BukkitScheduledTask(int taskId) {
            this.taskId = taskId;
        }

        @Override
        public void cancel() {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }

        @Override
        public boolean isCancelled() {
            return !Bukkit.getScheduler().isQueued(this.taskId) && !Bukkit.getScheduler().isCurrentlyRunning(this.taskId);
        }
    }
}

