/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.api.StorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.config.OreDictRegistry;
import com.jaquadro.minecraft.storagedrawers.config.RecipeHandlerRegistry;
import com.jaquadro.minecraft.storagedrawers.config.RenderRegistry;
import com.jaquadro.minecraft.storagedrawers.config.WailaRegistry;
import com.jaquadro.minecraft.storagedrawers.core.Api;
import com.jaquadro.minecraft.storagedrawers.core.CommonProxy;
import com.jaquadro.minecraft.storagedrawers.core.ForgeEventHandler;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.core.api.BlockRegistry;
import com.jaquadro.minecraft.storagedrawers.core.handlers.GuiHandler;
import com.jaquadro.minecraft.storagedrawers.integration.IntegrationRegistry;
import com.jaquadro.minecraft.storagedrawers.network.BlockClickMessage;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.security.SecurityRegistry;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="StorageDrawers", name="Storage Drawers", version="2.2.1-GTNH", dependencies="after:waila;", guiFactory="com.jaquadro.minecraft.storagedrawers.core.ModGuiFactory")
public class StorageDrawers {
    public static final String MOD_ID = "StorageDrawers";
    public static final String MOD_NAME = "Storage Drawers";
    public static final String MOD_VERSION = "2.2.1-GTNH";
    public static final String SOURCE_PATH = "com.jaquadro.minecraft.storagedrawers.";
    public static final Api api = new Api();
    public static final ModBlocks blocks = new ModBlocks();
    public static final ModItems items = new ModItems();
    public static final ModRecipes recipes = new ModRecipes();
    public static SimpleNetworkWrapper network;
    public static ConfigManager config;
    public static CompTierRegistry compRegistry;
    public static OreDictRegistry oreDictRegistry;
    public static RecipeHandlerRegistry recipeHandlerRegistry;
    public static RenderRegistry renderRegistry;
    public static WailaRegistry wailaRegistry;
    public static BlockRegistry blockRegistry;
    public static SecurityRegistry securityRegistry;
    @Mod.Instance(value="StorageDrawers")
    public static StorageDrawers instance;
    @SidedProxy(clientSide="com.jaquadro.minecraft.storagedrawers.core.ClientProxy", serverSide="com.jaquadro.minecraft.storagedrawers.core.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new ConfigManager(new File(event.getModConfigurationDirectory(), "StorageDrawers.cfg"));
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MOD_ID);
        network.registerMessage(BlockClickMessage.Handler.class, BlockClickMessage.class, 0, Side.SERVER);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            network.registerMessage(CountUpdateMessage.Handler.class, CountUpdateMessage.class, 1, Side.CLIENT);
        } else {
            network.registerMessage(CountUpdateMessage.HandlerStub.class, CountUpdateMessage.class, 1, Side.CLIENT);
        }
        compRegistry = new CompTierRegistry();
        oreDictRegistry = new OreDictRegistry();
        recipeHandlerRegistry = new RecipeHandlerRegistry();
        renderRegistry = new RenderRegistry();
        wailaRegistry = new WailaRegistry();
        blockRegistry = new BlockRegistry();
        securityRegistry = new SecurityRegistry();
        blocks.init();
        items.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandler());
        IntegrationRegistry.instance().init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        recipes.init();
        IntegrationRegistry.instance().postInit();
        StorageDrawersApi.instance().packFactory().registerResolver(ModBlocks.resolver);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(MOD_ID)) {
            config.syncConfig();
        }
    }
}

