/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomDrawers;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDrawersCustom
extends BlockDrawers {
    @SideOnly(value=Side.CLIENT)
    private IIcon overlayHandle;
    @SideOnly(value=Side.CLIENT)
    private IIcon overlayFaceShadow;
    @SideOnly(value=Side.CLIENT)
    private IIcon overlayTrimShadow;
    @SideOnly(value=Side.CLIENT)
    private IIcon overlayTrimFace;
    @SideOnly(value=Side.CLIENT)
    private IIcon defaultFace;
    @SideOnly(value=Side.CLIENT)
    private IIcon defaultTrim;

    public BlockDrawersCustom(String blockName, int drawerCount, boolean halfDepth) {
        super(blockName, drawerCount, halfDepth);
    }

    @Override
    public int getRenderType() {
        return StorageDrawers.proxy.drawersCustomRenderID;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        return true;
    }

    @Override
    public BlockType retrimType() {
        return null;
    }

    @Override
    protected ItemStack getMainDrop(World world, int x, int y, int z, int metadata) {
        TileEntityDrawers tile = BlockDrawersCustom.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return ItemCustomDrawers.makeItemStack((Block)this, 1, null, null, null);
        }
        return ItemCustomDrawers.makeItemStack((Block)this, 1, tile.getMaterialSide(), tile.getMaterialTrim(), tile.getMaterialFront());
    }

    @Override
    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List list) {
        if (StorageDrawers.config.cache.addonShowVanilla) {
            list.add(new ItemStack(item));
        }
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityDrawers tile = BlockDrawersCustom.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile != null && tile.getMaterialSide() == null) {
            return false;
        }
        return super.onBlockActivated(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getHandleOverlay() {
        return this.overlayHandle;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getFaceShadowOverlay() {
        return this.overlayFaceShadow;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getTrimShadowOverlay(boolean strong) {
        if (strong) {
            return this.overlayTrimFace;
        }
        return this.overlayTrimShadow;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getDefaultFaceIcon() {
        return this.defaultFace;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getDefaultTrimIcon() {
        return this.defaultTrim;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        super.registerBlockIcons(register);
        this.overlayHandle = register.registerIcon("StorageDrawers:overlay/handle_" + this.drawerCount);
        this.overlayFaceShadow = register.registerIcon("StorageDrawers:overlay/shading_face_" + this.drawerCount);
        this.overlayTrimShadow = register.registerIcon("StorageDrawers:overlay/shading_trim_" + this.drawerCount);
        this.overlayTrimFace = register.registerIcon("StorageDrawers:overlay/shading_boldtrim_" + this.drawerCount);
        this.defaultFace = register.registerIcon("StorageDrawers:base/base_default");
        this.defaultTrim = register.registerIcon("StorageDrawers:base/trim_default");
        this.iconSide[0] = register.registerIcon("StorageDrawers:drawers_raw_side");
        this.iconSideV[0] = register.registerIcon("StorageDrawers:drawers_raw_side");
        this.iconSideH[0] = register.registerIcon("StorageDrawers:drawers_raw_side");
        this.iconTrim[0] = register.registerIcon("StorageDrawers:drawers_raw_side");
        this.iconFront1[0] = register.registerIcon("StorageDrawers:drawers_raw_front_1");
        this.iconFront2[0] = register.registerIcon("StorageDrawers:drawers_raw_front_2");
        this.iconFront4[0] = register.registerIcon("StorageDrawers:drawers_raw_front_4");
    }
}

