/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.inventory.IDrawerInventory;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IPriorityGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.ISmartGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockCoord;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntitySlave
extends TileEntity
implements IDrawerGroup,
IPriorityGroup,
ISmartGroup,
ISidedInventory {
    private BlockCoord controllerCoord;
    private BlockCoord selfCoord;
    private int[] inventorySlots = new int[]{0};
    private int[] drawerSlots = new int[]{0};

    public void ensureInitialized() {
        if (this.selfCoord == null) {
            this.selfCoord = new BlockCoord(this.xCoord, this.yCoord, this.zCoord);
            this.markDirty();
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.selfCoord = new BlockCoord(this.xCoord, this.yCoord, this.zCoord);
        if (tag.hasKey("Controller", 10)) {
            NBTTagCompound ctag = tag.getCompoundTag("Controller");
            this.controllerCoord = new BlockCoord(ctag.getInteger("x"), ctag.getInteger("y"), ctag.getInteger("z"));
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        if (this.controllerCoord != null) {
            NBTTagCompound ctag = new NBTTagCompound();
            ctag.setInteger("x", this.controllerCoord.x());
            ctag.setInteger("y", this.controllerCoord.y());
            ctag.setInteger("z", this.controllerCoord.z());
            tag.setTag("Controller", (NBTBase)ctag);
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.func_148857_g());
        this.getWorldObj().func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }

    public void bindController(int x, int y, int z) {
        if (this.controllerCoord != null && this.controllerCoord.x() == x && this.controllerCoord.y() == y && this.controllerCoord.z() == z) {
            return;
        }
        this.controllerCoord = new BlockCoord(x, y, z);
        this.markDirty();
    }

    public TileEntityController getController() {
        if (this.controllerCoord == null) {
            return null;
        }
        this.ensureInitialized();
        TileEntity te = this.worldObj.getTileEntity(this.controllerCoord.x(), this.controllerCoord.y(), this.controllerCoord.z());
        if (!(te instanceof TileEntityController)) {
            this.controllerCoord = null;
            this.markDirty();
            return null;
        }
        return (TileEntityController)te;
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return this.drawerSlots;
        }
        return controller.getAccessibleDrawerSlots();
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return this.inventorySlots;
        }
        return controller.getAccessibleSlotsFromSide(0);
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return false;
        }
        return controller.canInsertItem(slot, stack, 0);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return false;
        }
        return controller.canExtractItem(slot, stack, side);
    }

    public int getSizeInventory() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return 1;
        }
        return controller.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return null;
        }
        return controller.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int count) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return null;
        }
        return controller.decrStackSize(slot, count);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return null;
        }
        return controller.getStackInSlotOnClosing(slot);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return;
        }
        controller.setInventorySlotContents(slot, stack);
    }

    public String getInventoryName() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return "storageDrawers.container.unboundSlave";
        }
        return controller.getInventoryName();
    }

    public boolean hasCustomInventoryName() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return false;
        }
        return controller.hasCustomInventoryName();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return false;
        }
        return controller.isItemValidForSlot(slot, stack);
    }

    @Override
    public int getDrawerCount() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return 0;
        }
        return controller.getDrawerCount();
    }

    @Override
    public IDrawer getDrawer(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return null;
        }
        return controller.getDrawer(slot);
    }

    @Override
    public boolean isDrawerEnabled(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return false;
        }
        return controller.isDrawerEnabled(slot);
    }

    @Override
    public IDrawerInventory getDrawerInventory() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return null;
        }
        return controller.getDrawerInventory();
    }

    @Override
    public Iterable<Integer> enumerateDrawersForInsertion(ItemStack stack, boolean strict) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return new ArrayList<Integer>();
        }
        return controller.enumerateDrawersForInsertion(stack, strict);
    }

    @Override
    public Iterable<Integer> enumerateDrawersForExtraction(ItemStack stack, boolean strict) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return new ArrayList<Integer>();
        }
        return controller.enumerateDrawersForExtraction(stack, strict);
    }

    public void markDirty() {
        TileEntityController controller = this.getController();
        if (controller != null && controller.isValidSlave(this.selfCoord)) {
            controller.markDirty();
        }
        super.markDirty();
    }

    @Override
    public boolean markDirtyIfNeeded() {
        TileEntityController controller = this.getController();
        if (controller != null && controller.isValidSlave(this.selfCoord)) {
            return controller.markDirtyIfNeeded();
        }
        return false;
    }
}

