/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityTrim
extends TileEntity {
    private ItemStack materialSide;
    private ItemStack materialTrim;

    public ItemStack getMaterialSide() {
        return this.materialSide;
    }

    public ItemStack getMaterialTrim() {
        return this.materialTrim;
    }

    public ItemStack getEffectiveMaterialSide() {
        return this.materialSide;
    }

    public ItemStack getEffectiveMaterialTrim() {
        return this.materialTrim != null ? this.materialTrim : this.materialSide;
    }

    public void setMaterialSide(ItemStack material) {
        this.materialSide = material;
    }

    public void setMaterialTrim(ItemStack material) {
        this.materialTrim = material;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.materialSide = null;
        if (tag.hasKey("MatS")) {
            this.materialSide = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag.getCompoundTag("MatS"));
        }
        this.materialTrim = null;
        if (tag.hasKey("MatT")) {
            this.materialTrim = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag.getCompoundTag("MatT"));
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound itag;
        super.writeToNBT(tag);
        if (this.materialSide != null) {
            itag = new NBTTagCompound();
            this.materialSide.writeToNBT(itag);
            tag.setTag("MatS", (NBTBase)itag);
        }
        if (this.materialTrim != null) {
            itag = new NBTTagCompound();
            this.materialTrim.writeToNBT(itag);
            tag.setTag("MatT", (NBTBase)itag);
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.func_148857_g());
        this.getWorldObj().func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }
}

