/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.renderer.DrawersRenderer;
import com.jaquadro.minecraft.storagedrawers.client.renderer.common.CommonDrawerRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;

@ThreadSafeISBRH(perThread=true)
public class DrawersCustomRenderer
extends DrawersRenderer {
    private final CommonDrawerRenderer commonRender = new CommonDrawerRenderer();

    @Override
    protected void renderBaseBlock(IBlockAccess world, TileEntityDrawers tile, int x, int y, int z, BlockDrawers block, RenderBlocks renderer) {
        ItemStack materialTrim;
        ItemStack materialFront;
        BlockDrawersCustom custom = (BlockDrawersCustom)block;
        ItemStack materialSide = tile.getMaterialSide();
        if (materialSide == null) {
            materialSide = new ItemStack((Block)block);
        }
        if ((materialFront = tile.getMaterialFront()) == null) {
            materialFront = materialSide;
        }
        if ((materialTrim = tile.getMaterialTrim()) == null) {
            materialTrim = materialSide;
        }
        IIcon trimIcon = Block.getBlockFromItem((Item)materialTrim.getItem()).getIcon(4, materialTrim.getItemDamage());
        IIcon panelIcon = Block.getBlockFromItem((Item)materialSide.getItem()).getIcon(4, materialSide.getItemDamage());
        IIcon frontIcon = Block.getBlockFromItem((Item)materialFront.getItem()).getIcon(4, materialFront.getItemDamage());
        if (trimIcon == null) {
            trimIcon = custom.getDefaultTrimIcon();
        }
        if (panelIcon == null) {
            panelIcon = custom.getDefaultFaceIcon();
        }
        if (frontIcon == null) {
            frontIcon = custom.getDefaultFaceIcon();
        }
        if (ForgeHooksClient.getWorldRenderPass() == 0) {
            this.commonRender.renderBasePass(world, x, y, z, custom, tile.getDirection(), panelIcon, trimIcon, frontIcon);
        } else if (ForgeHooksClient.getWorldRenderPass() == 1) {
            this.commonRender.renderOverlayPass(world, x, y, z, custom, tile.getDirection(), trimIcon, frontIcon);
        }
    }

    @Override
    public int getRenderId() {
        return StorageDrawers.proxy.drawersCustomRenderID;
    }
}

