/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation;

import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.integration.RefinedRelocation;
import com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation.SortingBlockRegistry;
import com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation.TileSortingDrawersComp;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSortingCompDrawers
extends BlockCompDrawers {
    @SideOnly(value=Side.CLIENT)
    IIcon iconSort;

    public BlockSortingCompDrawers(String blockName) {
        super(blockName);
        this.setCreativeTab(RefinedRelocation.tabStorageDrawers);
    }

    public static boolean upgradeToSorting(World world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof TileEntityDrawersComp) || tile instanceof TileSortingDrawersComp) {
            return false;
        }
        Block block = world.getBlock(x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        TileEntityDrawersComp oldDrawer = (TileEntityDrawersComp)tile;
        TileSortingDrawersComp newDrawer = new TileSortingDrawersComp();
        NBTTagCompound tag = new NBTTagCompound();
        oldDrawer.writeToNBT(tag);
        newDrawer.readFromNBT(tag);
        world.removeTileEntity(x, y, z);
        world.setBlockToAir(x, y, z);
        Block sortingBlock = SortingBlockRegistry.resolveSortingBlock(block);
        if (sortingBlock != null) {
            world.setBlock(x, y, z, sortingBlock, meta, 3);
        }
        world.setTileEntity(x, y, z, (TileEntity)newDrawer);
        return true;
    }

    @Override
    public TileSortingDrawersComp createNewTileEntity(World world, int meta) {
        return new TileSortingDrawersComp();
    }

    @Override
    public IIcon getIcon(int side, int meta) {
        if (side == 1) {
            return this.iconSort;
        }
        return super.getIcon(side, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (side == 1) {
            return this.iconSort;
        }
        return super.getIcon(blockAccess, x, y, z, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        super.registerBlockIcons(register);
        this.iconSort = register.registerIcon("StorageDrawers:drawers_comp_sort");
    }
}

