/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStatus;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeVoid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryUpgrade
implements IInventory {
    private static final int upgradeCapacity = 5;
    private TileEntityDrawers tile;

    public InventoryUpgrade(TileEntityDrawers tileEntity) {
        this.tile = tileEntity;
    }

    public int getSizeInventory() {
        return 5;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.tile.getUpgrade(slot);
    }

    public ItemStack decrStackSize(int slot, int count) {
        ItemStack stack = this.tile.getUpgrade(slot);
        if (count > 0) {
            this.tile.setUpgrade(slot, null);
        }
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack item) {
        this.tile.setUpgrade(slot, item);
    }

    public String getInventoryName() {
        return this.tile.getInventoryName();
    }

    public boolean hasCustomInventoryName() {
        return this.tile.hasCustomInventoryName();
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public void markDirty() {
        this.tile.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.tile.isUseableByPlayer(player);
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack item) {
        return item.getItem() instanceof ItemUpgrade || item.getItem() instanceof ItemUpgradeStatus || item.getItem() instanceof ItemUpgradeVoid;
    }

    public boolean canRemoveStorageUpgrade(int storageLevel) {
        return this.canRemoveStorageUpgrade(this.tile, storageLevel);
    }

    private boolean canRemoveStorageUpgrade(TileEntityDrawers tile, int storageLevel) {
        int storageMult = StorageDrawers.config.getStorageUpgradeMultiplier(storageLevel);
        int effectiveStorageMult = tile.getEffectiveStorageMultiplier();
        if (effectiveStorageMult == storageMult) {
            --storageMult;
        }
        int addedStackCapacity = storageMult * tile.getDrawerCapacity();
        for (int i = 0; i < tile.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!tile.isDrawerEnabled(i) || (drawer = tile.getDrawer(i)).isEmpty()) continue;
            int addedItemCapacity = addedStackCapacity * drawer.getStoredItemStackSize();
            if (drawer.getMaxCapacity() - addedItemCapacity >= drawer.getStoredItemCount()) continue;
            return false;
        }
        return true;
    }
}

