/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemDrawers
extends ItemBlock {
    public ItemDrawers(Block block) {
        super(block);
        this.setMaxDamage(0);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            return false;
        }
        TileEntityDrawers tile = (TileEntityDrawers)world.getTileEntity(x, y, z);
        if (tile != null) {
            BlockDrawers block = (BlockDrawers)this.field_150939_a;
            if (tile instanceof TileEntityDrawersStandard) {
                ((TileEntityDrawersStandard)tile).setDrawerCount(block.drawerCount);
            }
            tile.setDrawerCapacity(this.getCapacityForBlock((Block)block));
            if (stack.hasTagCompound() && stack.getTagCompound().hasKey("tile")) {
                tile.readFromPortableNBT(stack.getTagCompound().getCompoundTag("tile"));
            }
            if (side > 1) {
                tile.setDirection(side);
            }
            tile.setIsSealed(false);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        if (itemStack.hasTagCompound()) {
            NBTTagCompound tag = itemStack.getTagCompound();
            if (tag.hasKey("tile")) {
                NBTTagCompound tileTag = tag.getCompoundTag("tile");
                ItemStack[] upgrades = new ItemStack[5];
                int drawerCapacity = this.getUpgradesAndDrawerCapacity(tileTag, upgrades);
                this.addDescriptionInformation(drawerCapacity, list);
                if (Keyboard.isKeyDown((int)42)) {
                    this.addStatsInformation(tileTag, player, list);
                    this.addDrawersInformation(tileTag, list);
                    this.addUpgradesInformation(upgrades, list);
                    this.addSealedContentsInformation(tileTag, list);
                } else {
                    list.add(EnumChatFormatting.YELLOW + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed"));
                    list.add(EnumChatFormatting.DARK_GRAY + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.descriptionShift"));
                }
            } else {
                this.addAlternativeTagInformation(itemStack, player, list, par4);
            }
        } else {
            Block block = Block.getBlockFromItem((Item)itemStack.getItem());
            this.addNoneTagDescriptionInformation(this.getCapacityForBlock(block), list);
        }
    }

    protected int getCapacityForBlock(Block block) {
        ConfigManager config = StorageDrawers.config;
        int count = 0;
        if (!(block instanceof BlockDrawers)) {
            return 0;
        }
        BlockDrawers drawer = (BlockDrawers)block;
        if (drawer.drawerCount == 1) {
            count = config.getBlockBaseStorage("fulldrawers1");
        } else if (drawer.drawerCount == 2 && !drawer.halfDepth) {
            count = config.getBlockBaseStorage("fulldrawers2");
        } else if (drawer.drawerCount == 4 && !drawer.halfDepth) {
            count = config.getBlockBaseStorage("fulldrawers4");
        } else if (drawer.drawerCount == 2 && drawer.halfDepth) {
            count = config.getBlockBaseStorage("halfdrawers2");
        } else if (drawer.drawerCount == 4 && drawer.halfDepth) {
            count = config.getBlockBaseStorage("halfdrawers4");
        } else if (drawer.drawerCount == 3) {
            count = config.getBlockBaseStorage("compDrawers");
        }
        return count;
    }

    protected void addDescriptionInformation(int drawerCapacity, List list) {
        list.add(StatCollector.translateToLocalFormatted((String)"storageDrawers.drawers.description", (Object[])new Object[]{drawerCapacity}));
    }

    protected void addNoneTagDescriptionInformation(int drawerCapacity, List list) {
        this.addDescriptionInformation(drawerCapacity, list);
    }

    protected void addAlternativeTagInformation(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
    }

    protected void addStatsInformation(NBTTagCompound tag, EntityPlayer player, List list) {
        ConfigManager config = StorageDrawers.config;
        EnumSet<LockAttribute> lockAttributes = null;
        UUID owner = null;
        boolean shrouded = false;
        boolean quantified = false;
        if (config.cache.enableLockUpgrades && tag.hasKey("Lock")) {
            lockAttributes = LockAttribute.getEnumSet(tag.getByte("Lock"));
        }
        if (config.cache.enablePersonalUpgrades && tag.hasKey("Own")) {
            owner = UUID.fromString(tag.getString("Own"));
        }
        if (config.cache.enableShroudUpgrades && tag.hasKey("Shr")) {
            shrouded = tag.getBoolean("Shr");
        }
        if (config.cache.enableQuantifyUpgrades && tag.hasKey("Qua")) {
            quantified = tag.getBoolean("Qua");
        }
        String lockInfo = lockAttributes != null && lockAttributes.contains((Object)LockAttribute.LOCK_POPULATED) ? EnumChatFormatting.YELLOW + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.locked") : EnumChatFormatting.DARK_GRAY + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.unlocked");
        String accessInfo = owner != null ? (player.getUniqueID().equals(owner) ? EnumChatFormatting.GREEN + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.access_owner") : EnumChatFormatting.RED + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.access_owner")) : EnumChatFormatting.DARK_GRAY + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.access_public");
        list.add(lockInfo + EnumChatFormatting.DARK_GRAY + ", " + accessInfo);
        if (shrouded) {
            list.add(EnumChatFormatting.WHITE + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.hideItemLabel"));
        } else {
            list.add(EnumChatFormatting.DARK_GRAY + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.showItemLabel"));
        }
        if (quantified) {
            list.add(EnumChatFormatting.WHITE + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.showItemQuantity"));
        } else {
            list.add(EnumChatFormatting.DARK_GRAY + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.hideItemQuantity"));
        }
    }

    protected void addDrawersInformation(NBTTagCompound tag, List list) {
        NBTTagList slots = tag.getTagList("Slots", 10);
        list.add(EnumChatFormatting.GRAY + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.drawerList"));
        for (int i = 0; i < slots.tagCount(); ++i) {
            NBTTagCompound slot = slots.getCompoundTagAt(i);
            ItemStack stack = this.getItemStackFromDrawer(slot);
            String slotCounter = EnumChatFormatting.YELLOW + " #" + (i + 1) + ": ";
            if (stack != null) {
                list.add(slotCounter + this.getGoodDisplayName(stack) + " " + this.getItemCountDisplay(stack.getMaxStackSize(), slot.getInteger("Count")));
                continue;
            }
            list.add(slotCounter + EnumChatFormatting.DARK_GRAY + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.drawerEmpty"));
        }
    }

    protected void addUpgradesInformation(ItemStack[] upgrades, List list) {
        list.add(EnumChatFormatting.GRAY + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.upgradeList"));
        boolean hasUpgrades = false;
        for (int i = 0; i < upgrades.length; ++i) {
            ItemStack upgrade = upgrades[i];
            if (upgrade == null) continue;
            list.add(EnumChatFormatting.YELLOW + "  - " + this.getGoodDisplayName(upgrade));
            hasUpgrades = true;
        }
        if (!hasUpgrades) {
            list.add("  " + EnumChatFormatting.DARK_GRAY + StatCollector.translateToLocal((String)"storageDrawers.drawers.sealed.upgradeNone"));
        }
    }

    protected void addSealedContentsInformation(NBTTagCompound tag, List list) {
    }

    protected ItemStack getItemStackFromDrawer(NBTTagCompound slot) {
        Item item;
        ItemStack stack = null;
        if (slot.hasKey("Item") && slot.hasKey("Count") && (item = Item.getItemById((int)slot.getShort("Item"))) != null) {
            stack = new ItemStack(item, 1, (int)slot.getShort("Meta"));
            if (slot.hasKey("Tags")) {
                stack.setTagCompound(slot.getCompoundTag("Tags"));
            }
        }
        return stack;
    }

    protected int getUpgradesAndDrawerCapacity(NBTTagCompound tag, ItemStack[] upgrades) {
        ConfigManager config = StorageDrawers.config;
        int multiplier = 0;
        boolean isDowngrade = false;
        if (!tag.hasKey("Upgrades")) {
            int i = 0;
            if (tag.hasKey("Lev") && tag.getByte("Lev") > 1) {
                upgrades[i] = new ItemStack((Item)ModItems.upgrade, 1, (int)tag.getByte("Lev"));
                multiplier += config.getStorageUpgradeMultiplier(upgrades[i++].getItemDamage());
            }
            if (tag.hasKey("Stat")) {
                upgrades[i++] = new ItemStack((Item)ModItems.upgradeStatus, 1, (int)tag.getByte("Stat"));
            }
            if (tag.hasKey("Void")) {
                upgrades[i++] = new ItemStack((Item)ModItems.upgradeVoid);
            }
            if (tag.hasKey("Down")) {
                upgrades[i] = new ItemStack((Item)ModItems.upgradeDowngrade);
                isDowngrade = true;
            }
        } else {
            NBTTagList upgradeList = tag.getTagList("Upgrades", 10);
            for (int i = 0; i < upgradeList.tagCount(); ++i) {
                NBTTagCompound upgradeTag = upgradeList.getCompoundTagAt(i);
                ItemStack stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)upgradeTag);
                if (stack != null) {
                    if (stack.getItem() == ModItems.upgrade) {
                        multiplier += StorageDrawers.config.getStorageUpgradeMultiplier(stack.getItemDamage());
                    }
                    if (stack.getItem() == ModItems.upgradeDowngrade) {
                        isDowngrade = true;
                    }
                }
                upgrades[i] = stack;
            }
        }
        if (multiplier == 0) {
            multiplier = 1;
        }
        return isDowngrade ? multiplier : tag.getShort("Cap") * multiplier;
    }

    protected String getGoodDisplayName(ItemStack stack) {
        if (stack.hasDisplayName()) {
            return EnumChatFormatting.ITALIC.toString() + stack.getRarity().rarityColor + stack.getDisplayName();
        }
        return stack.getRarity().rarityColor.toString() + stack.getDisplayName();
    }

    protected String getItemCountDisplay(int maxStackSize, int itemCount) {
        int numStack = itemCount / maxStackSize;
        int remainder = itemCount - numStack * maxStackSize;
        String itemCountDisplay = numStack > 0 ? (remainder > 0 ? "[" + numStack + "x" + maxStackSize + " + " + remainder + "]" : "[" + numStack + "x" + maxStackSize + "]") : "[" + remainder + "]";
        return EnumChatFormatting.BLUE + itemCountDisplay;
    }
}

