/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.util.RenderHelperAO;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelperState;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;

public class RenderHelperLL {
    private static final int TL = 0;
    private static final int BL = 1;
    private static final int BR = 2;
    private static final int TR = 3;
    private static final int MINX = 0;
    private static final int MAXX = 1;
    private static final int MINY = 2;
    private static final int MAXY = 3;
    private static final int MINZ = 4;
    private static final int MAXZ = 5;
    private static final int[][][] xyzuvMap = new int[][][]{new int[][]{{0, 2, 5, 0, 2}, {0, 2, 4, 0, 3}, {1, 2, 4, 1, 3}, {1, 2, 5, 1, 2}}, new int[][]{{1, 3, 5, 0, 2}, {1, 3, 4, 0, 3}, {0, 3, 4, 1, 3}, {0, 3, 5, 1, 2}}, new int[][]{{0, 3, 4, 0, 2}, {1, 3, 4, 1, 2}, {1, 2, 4, 1, 3}, {0, 2, 4, 0, 3}}, new int[][]{{0, 3, 5, 0, 2}, {0, 2, 5, 0, 3}, {1, 2, 5, 1, 3}, {1, 3, 5, 1, 2}}, new int[][]{{0, 3, 5, 0, 2}, {0, 3, 4, 1, 2}, {0, 2, 4, 1, 3}, {0, 2, 5, 0, 3}}, new int[][]{{1, 2, 5, 0, 2}, {1, 2, 4, 1, 2}, {1, 3, 4, 1, 3}, {1, 3, 5, 0, 3}}};
    private RenderHelperState state;
    private double[] minUDiv = new double[24];
    private double[] maxUDiv = new double[24];
    private double[] minVDiv = new double[24];
    private double[] maxVDiv = new double[24];
    private int[][] brightnessLerp = new int[10][10];
    private double[] uv = new double[4];
    private double[] xyz = new double[6];

    public RenderHelperLL(RenderHelperState state) {
        this.state = state;
    }

    public void drawFace(int face, double x, double y, double z, IIcon icon) {
        boolean flip = this.state.flipTexture;
        switch (face) {
            case 0: 
            case 1: {
                this.drawFaceY(face, x, y, z, icon);
                break;
            }
            case 2: 
            case 3: {
                if (this.state.rotateTransform == 2 || this.state.rotateTransform == 1) {
                    this.state.flipTexture = !this.state.flipTexture;
                }
                this.drawFaceZ(face, x, y, z, icon);
                break;
            }
            case 4: 
            case 5: {
                if (this.state.rotateTransform == 2 || this.state.rotateTransform == 3) {
                    this.state.flipTexture = !this.state.flipTexture;
                }
                this.drawFaceX(face, x, y, z, icon);
            }
        }
        this.state.flipTexture = flip;
    }

    private void drawFaceY(int face, double x, double y, double z, IIcon icon) {
        int rotate;
        if (icon == null) {
            return;
        }
        int rangeX = (int)(Math.ceil(this.state.renderMaxX + (double)this.state.shiftU) - Math.floor(this.state.renderMinX + (double)this.state.shiftU));
        int rangeZ = (int)(Math.ceil(this.state.renderMaxZ + (double)this.state.shiftV) - Math.floor(this.state.renderMinZ + (double)this.state.shiftV));
        this.setXYZ(x, y, z);
        if (this.state.renderFromInside) {
            this.xyz[0] = z + this.state.renderMaxX;
            this.xyz[1] = z + this.state.renderMinX;
        }
        int n = rotate = face == 0 ? this.state.uvRotate[0] : this.state.uvRotate[1];
        if (rangeX <= 1 && rangeZ <= 1) {
            if (face == 0) {
                this.setFaceYNegUV(icon, this.state.renderMinX, this.state.renderMinZ, this.state.renderMaxX, this.state.renderMaxZ);
            } else {
                this.setFaceYPosUV(icon, this.state.renderMinX, this.state.renderMinZ, this.state.renderMaxX, this.state.renderMaxZ);
            }
            if (this.state.enableAO) {
                this.renderXYZUVAO(xyzuvMap[face], this.state.uvRotate[face]);
            } else {
                this.renderXYZUV(xyzuvMap[face], this.state.uvRotate[face]);
            }
            return;
        }
        double uStart = (this.state.renderMinX + (double)this.state.shiftU + (double)rangeX) % 1.0;
        double uStop = (this.state.renderMaxX + (double)this.state.shiftU + (double)rangeX) % 1.0;
        double vStart = (this.state.renderMinZ + (double)this.state.shiftV + (double)rangeZ) % 1.0;
        double vStop = (this.state.renderMaxZ + (double)this.state.shiftV + (double)rangeZ) % 1.0;
        this.setupUVPoints(uStart, vStart, uStop, vStop, rangeX, rangeZ, icon);
        this.setupAOBrightnessLerp(this.state.renderMinX, this.state.renderMaxX, this.state.renderMinZ, this.state.renderMaxZ, rangeX, rangeZ);
        for (int ix = 0; ix < rangeX; ++ix) {
            this.xyz[1] = this.xyz[0] + this.maxUDiv[ix] - this.minUDiv[ix];
            this.xyz[4] = z + this.state.renderMinZ;
            for (int iz = 0; iz < rangeZ; ++iz) {
                this.xyz[5] = this.xyz[4] + this.maxVDiv[iz] - this.minVDiv[iz];
                this.state.brightnessTopLeft = this.brightnessLerp[ix][iz];
                this.state.brightnessTopRight = this.brightnessLerp[ix + 1][iz];
                this.state.brightnessBottomLeft = this.brightnessLerp[ix][iz + 1];
                this.state.brightnessBottomRight = this.brightnessLerp[ix + 1][iz + 1];
                switch (rotate) {
                    case 1: {
                        this.setUV(icon, this.maxVDiv[ix], this.minVDiv[ix], this.minUDiv[iz], this.maxUDiv[iz]);
                        break;
                    }
                    case 2: {
                        this.setUV(icon, this.maxUDiv[ix], this.minUDiv[ix], this.maxVDiv[iz], this.minVDiv[iz]);
                        break;
                    }
                    case 3: {
                        this.setUV(icon, this.minVDiv[ix], this.maxVDiv[ix], this.maxUDiv[iz], this.minUDiv[iz]);
                        break;
                    }
                    default: {
                        this.setUV(icon, this.minUDiv[ix], this.maxUDiv[ix], this.minVDiv[iz], this.maxVDiv[iz]);
                    }
                }
                this.renderXYZUVAO(xyzuvMap[face], this.state.uvRotate[face]);
                this.xyz[4] = this.xyz[5];
            }
            this.xyz[0] = this.xyz[1];
        }
    }

    private void setFaceYNegUV(IIcon icon, double minX, double minZ, double maxX, double maxZ) {
        int rotate = this.state.uvRotate[0];
        if (rotate == 0) {
            this.setUV(icon, minX + (double)this.state.shiftU, maxX + (double)this.state.shiftU, maxZ + (double)this.state.shiftV, minZ + (double)this.state.shiftV);
        }
        if (rotate == 1) {
            this.setUV(icon, 1.0 - maxZ + (double)this.state.shiftU, 1.0 - minZ + (double)this.state.shiftU, minX + (double)this.state.shiftV, maxX + (double)this.state.shiftV);
        }
        if (rotate == 2) {
            this.setUV(icon, 1.0 - minX + (double)this.state.shiftU, 1.0 - maxX + (double)this.state.shiftU, 1.0 - maxZ + (double)this.state.shiftV, 1.0 - minZ + (double)this.state.shiftV);
        }
        if (rotate == 3) {
            this.setUV(icon, maxZ + (double)this.state.shiftU, minZ + (double)this.state.shiftU, 1.0 - minX + (double)this.state.shiftV, 1.0 - maxX + (double)this.state.shiftV);
        }
    }

    private void setFaceYPosUV(IIcon icon, double minX, double minZ, double maxX, double maxZ) {
        int rotate = this.state.uvRotate[1];
        if (rotate == 0) {
            this.setUV(icon, maxX + (double)this.state.shiftU, minX + (double)this.state.shiftU, maxZ + (double)this.state.shiftV, minZ + (double)this.state.shiftV);
        }
        if (rotate == 1) {
            this.setUV(icon, maxZ + (double)this.state.shiftU, minZ + (double)this.state.shiftU, 1.0 - maxX + (double)this.state.shiftV, 1.0 - minX + (double)this.state.shiftV);
        }
        if (rotate == 2) {
            this.setUV(icon, 1.0 - maxX + (double)this.state.shiftU, 1.0 - minX + (double)this.state.shiftU, 1.0 - maxZ + (double)this.state.shiftV, 1.0 - minZ + (double)this.state.shiftV);
        }
        if (rotate == 3) {
            this.setUV(icon, 1.0 - maxZ + (double)this.state.shiftU, 1.0 - minZ + (double)this.state.shiftU, maxX + (double)this.state.shiftV, minX + (double)this.state.shiftV);
        }
    }

    private void drawFaceZ(int face, double x, double y, double z, IIcon icon) {
        if (icon == null) {
            return;
        }
        int rangeX = (int)(Math.ceil(this.state.renderMaxX + (double)this.state.shiftU) - Math.floor(this.state.renderMinX + (double)this.state.shiftU));
        int rangeY = (int)(Math.ceil(this.state.renderMaxY + (double)this.state.shiftV) - Math.floor(this.state.renderMinY + (double)this.state.shiftV));
        this.setXYZ(x, y, z);
        if (this.state.renderFromInside) {
            this.xyz[0] = z + this.state.renderMaxX;
            this.xyz[1] = z + this.state.renderMinX;
        }
        if (rangeX <= 1 && rangeY <= 1) {
            double minX = this.state.renderMinX;
            double maxX = this.state.renderMaxX;
            if (this.state.flipTexture) {
                minX = this.state.renderMaxX;
                maxX = this.state.renderMinX;
            }
            if (face == 2) {
                this.setFaceZNegUV(icon, minX, this.state.renderMinY, maxX, this.state.renderMaxY);
            } else {
                this.setFaceZPosUV(icon, minX, this.state.renderMinY, maxX, this.state.renderMaxY);
            }
            if (this.state.enableAO) {
                this.renderXYZUVAO(xyzuvMap[face], this.state.uvRotate[face]);
            } else {
                this.renderXYZUV(xyzuvMap[face], this.state.uvRotate[face]);
            }
            return;
        }
        double uStart = (this.state.renderMinX + (double)this.state.shiftU + (double)rangeX) % 1.0;
        double uStop = (this.state.renderMaxX + (double)this.state.shiftU + (double)rangeX) % 1.0;
        double vStart = (this.state.renderMinY + (double)this.state.shiftV + (double)rangeY) % 1.0;
        double vStop = (this.state.renderMaxY + (double)this.state.shiftV + (double)rangeY) % 1.0;
        this.setupUVPoints(uStart, vStart, uStop, vStop, rangeX, rangeY, icon);
        this.setupAOBrightnessLerp(this.state.renderMinX, this.state.renderMaxX, this.state.renderMinY, this.state.renderMaxY, rangeX, rangeY);
        for (int ix = 0; ix < rangeX; ++ix) {
            this.xyz[1] = this.xyz[0] + this.maxUDiv[ix] - this.minUDiv[ix];
            this.xyz[2] = y + this.state.renderMinY;
            for (int iy = 0; iy < rangeY; ++iy) {
                this.xyz[3] = this.xyz[2] + this.maxVDiv[iy] - this.minVDiv[iy];
                this.state.brightnessTopLeft = this.brightnessLerp[ix][iy];
                this.state.brightnessTopRight = this.brightnessLerp[ix + 1][iy];
                this.state.brightnessBottomLeft = this.brightnessLerp[ix][iy + 1];
                this.state.brightnessBottomRight = this.brightnessLerp[ix + 1][iy + 1];
                if (this.state.flipTexture) {
                    this.setUV(icon, 1.0 - this.minUDiv[ix], 1.0 - this.maxUDiv[ix], 1.0 - this.maxVDiv[iy], 1.0 - this.minVDiv[iy]);
                } else {
                    this.setUV(icon, this.minUDiv[ix], this.maxUDiv[ix], 1.0 - this.maxVDiv[iy], 1.0 - this.minVDiv[iy]);
                }
                this.renderXYZUVAO(xyzuvMap[face], this.state.uvRotate[face]);
                this.xyz[2] = this.xyz[3];
            }
            this.xyz[0] = this.xyz[1];
        }
    }

    private void setFaceZNegUV(IIcon icon, double minX, double minY, double maxX, double maxY) {
        int rotate = this.state.uvRotate[2];
        if (rotate == 0) {
            this.setUV(icon, maxX + (double)this.state.shiftU, minX + (double)this.state.shiftU, 1.0 - maxY + (double)this.state.shiftV, 1.0 - minY + (double)this.state.shiftV);
        }
        if (rotate == 1) {
            this.setUV(icon, 1.0 - minY + (double)this.state.shiftU, 1.0 - maxY + (double)this.state.shiftU, minX + (double)this.state.shiftV, maxX + (double)this.state.shiftV);
        }
        if (rotate == 2) {
            this.setUV(icon, 1.0 - maxX + (double)this.state.shiftU, 1.0 - minX + (double)this.state.shiftU, maxY + (double)this.state.shiftV, minY + (double)this.state.shiftV);
        }
        if (rotate == 3) {
            this.setUV(icon, minY + (double)this.state.shiftU, maxY + (double)this.state.shiftU, 1.0 - minX + (double)this.state.shiftV, 1.0 - maxX + (double)this.state.shiftV);
        }
    }

    private void setFaceZPosUV(IIcon icon, double minX, double minY, double maxX, double maxY) {
        int rotate = this.state.uvRotate[3];
        if (rotate == 0) {
            this.setUV(icon, minX + (double)this.state.shiftU, maxX + (double)this.state.shiftU, 1.0 - maxY + (double)this.state.shiftV, 1.0 - minY + (double)this.state.shiftV);
        }
        if (rotate == 1) {
            this.setUV(icon, minY + (double)this.state.shiftU, maxY + (double)this.state.shiftU, 1.0 - minX + (double)this.state.shiftV, 1.0 - maxX + (double)this.state.shiftV);
        }
        if (rotate == 2) {
            this.setUV(icon, 1.0 - minX + (double)this.state.shiftU, 1.0 - maxX + (double)this.state.shiftU, maxY + (double)this.state.shiftV, minY + (double)this.state.shiftV);
        }
        if (rotate == 3) {
            this.setUV(icon, 1.0 - minY + (double)this.state.shiftU, 1.0 - maxY + (double)this.state.shiftU, minX + (double)this.state.shiftV, maxX + (double)this.state.shiftV);
        }
    }

    private void drawFaceX(int face, double x, double y, double z, IIcon icon) {
        if (icon == null) {
            return;
        }
        int rangeZ = (int)(Math.ceil(this.state.renderMaxZ + (double)this.state.shiftU) - Math.floor(this.state.renderMinZ + (double)this.state.shiftU));
        int rangeY = (int)(Math.ceil(this.state.renderMaxY + (double)this.state.shiftV) - Math.floor(this.state.renderMinY + (double)this.state.shiftV));
        this.setXYZ(x, y, z);
        if (this.state.renderFromInside) {
            this.xyz[4] = z + this.state.renderMaxZ;
            this.xyz[5] = z + this.state.renderMinZ;
        }
        if (rangeZ <= 1 && rangeY <= 1) {
            double minZ = this.state.renderMinZ;
            double maxZ = this.state.renderMaxZ;
            if (this.state.flipTexture) {
                minZ = this.state.renderMaxZ;
                maxZ = this.state.renderMinZ;
            }
            if (face == 4) {
                this.setFaceXNegUV(icon, minZ, this.state.renderMinY, maxZ, this.state.renderMaxY);
            } else {
                this.setFaceXPosUV(icon, minZ, this.state.renderMinY, maxZ, this.state.renderMaxY);
            }
            if (this.state.enableAO) {
                this.renderXYZUVAO(xyzuvMap[face], this.state.uvRotate[face]);
            } else {
                this.renderXYZUV(xyzuvMap[face], this.state.uvRotate[face]);
            }
            return;
        }
        double uStart = (this.state.renderMinZ + (double)this.state.shiftU + (double)rangeZ) % 1.0;
        double uStop = (this.state.renderMaxZ + (double)this.state.shiftU + (double)rangeZ) % 1.0;
        double vStart = (this.state.renderMinY + (double)this.state.shiftV + (double)rangeY) % 1.0;
        double vStop = (this.state.renderMaxY + (double)this.state.shiftV + (double)rangeY) % 1.0;
        this.setupUVPoints(uStart, vStart, uStop, vStop, rangeZ, rangeY, icon);
        this.setupAOBrightnessLerp(this.state.renderMinZ, this.state.renderMaxZ, this.state.renderMinY, this.state.renderMaxY, rangeZ, rangeY);
        for (int iz = 0; iz < rangeZ; ++iz) {
            this.xyz[5] = this.xyz[4] + this.maxUDiv[iz] - this.minUDiv[iz];
            this.xyz[2] = y + this.state.renderMinY;
            for (int iy = 0; iy < rangeY; ++iy) {
                this.xyz[3] = this.xyz[2] + this.maxVDiv[iy] - this.minVDiv[iy];
                this.state.brightnessTopLeft = this.brightnessLerp[iz][iy];
                this.state.brightnessTopRight = this.brightnessLerp[iz + 1][iy];
                this.state.brightnessBottomLeft = this.brightnessLerp[iz][iy + 1];
                this.state.brightnessBottomRight = this.brightnessLerp[iz + 1][iy + 1];
                if (this.state.flipTexture) {
                    this.setUV(icon, 1.0 - this.minUDiv[iz], 1.0 - this.maxUDiv[iz], 1.0 - this.maxVDiv[iy], 1.0 - this.minVDiv[iy]);
                } else {
                    this.setUV(icon, this.minUDiv[iz], this.maxUDiv[iz], 1.0 - this.maxVDiv[iy], 1.0 - this.minVDiv[iy]);
                }
                this.renderXYZUVAO(xyzuvMap[face], this.state.uvRotate[face]);
                this.xyz[2] = this.xyz[3];
            }
            this.xyz[4] = this.xyz[5];
        }
    }

    private void setFaceXNegUV(IIcon icon, double minZ, double minY, double maxZ, double maxY) {
        int rotate = this.state.uvRotate[4];
        if (rotate == 0) {
            this.setUV(icon, maxZ + (double)this.state.shiftU, minZ + (double)this.state.shiftU, 1.0 - maxY + (double)this.state.shiftV, 1.0 - minY + (double)this.state.shiftV);
        }
        if (rotate == 1) {
            this.setUV(icon, minY + (double)this.state.shiftU, maxY + (double)this.state.shiftU, 1.0 - maxZ + (double)this.state.shiftV, 1.0 - minZ + (double)this.state.shiftV);
        }
        if (rotate == 2) {
            this.setUV(icon, 1.0 - maxZ + (double)this.state.shiftU, 1.0 - minZ + (double)this.state.shiftU, maxY + (double)this.state.shiftV, minY + (double)this.state.shiftV);
        }
        if (rotate == 3) {
            this.setUV(icon, 1.0 - minY + (double)this.state.shiftU, 1.0 - maxY + (double)this.state.shiftU, maxZ + (double)this.state.shiftV, minZ + (double)this.state.shiftV);
        }
    }

    private void setFaceXPosUV(IIcon icon, double minZ, double minY, double maxZ, double maxY) {
        int rotate = this.state.uvRotate[5];
        if (rotate == 0) {
            this.setUV(icon, minZ + (double)this.state.shiftU, maxZ + (double)this.state.shiftU, 1.0 - minY + (double)this.state.shiftV, 1.0 - maxY + (double)this.state.shiftV);
        }
        if (rotate == 1) {
            this.setUV(icon, 1.0 - maxY + (double)this.state.shiftU, 1.0 - minY + (double)this.state.shiftU, maxZ + (double)this.state.shiftV, minZ + (double)this.state.shiftV);
        }
        if (rotate == 2) {
            this.setUV(icon, 1.0 - minZ + (double)this.state.shiftU, 1.0 - maxZ + (double)this.state.shiftU, minY + (double)this.state.shiftV, maxY + (double)this.state.shiftV);
        }
        if (rotate == 3) {
            this.setUV(icon, maxY + (double)this.state.shiftU, minY + (double)this.state.shiftU, 1.0 - maxZ + (double)this.state.shiftV, 1.0 - minZ + (double)this.state.shiftV);
        }
    }

    public void drawPartialFace(int face, double x, double y, double z, IIcon icon, double uMin, double vMin, double uMax, double vMax) {
        this.setXYZ(x, y, z);
        this.setUV(icon, uMin, uMax, vMin, vMax);
        if (this.state.enableAO) {
            this.renderXYZUVAO(xyzuvMap[face], this.state.uvRotate[face]);
        } else {
            this.renderXYZUV(xyzuvMap[face], this.state.uvRotate[face]);
        }
    }

    private void setupUVPoints(double uStart, double vStart, double uStop, double vStop, int rangeU, int rangeV, IIcon icon) {
        int i;
        if (rangeU <= 1) {
            this.minUDiv[0] = uStart;
            this.maxUDiv[0] = uStop;
        } else {
            this.minUDiv[0] = uStart;
            this.maxUDiv[0] = 1.0;
            for (i = 1; i < rangeU - 1; ++i) {
                this.minUDiv[i] = 0.0;
                this.maxUDiv[i] = 1.0;
            }
            this.minUDiv[rangeU - 1] = 0.0;
            this.maxUDiv[rangeU - 1] = uStop;
        }
        if (rangeV <= 1) {
            this.minVDiv[0] = vStart;
            this.maxVDiv[0] = vStop;
        } else {
            this.minVDiv[0] = vStart;
            this.maxVDiv[0] = 1.0;
            for (i = 1; i < rangeV - 1; ++i) {
                this.minVDiv[i] = 0.0;
                this.maxVDiv[i] = 1.0;
            }
            this.minVDiv[rangeV - 1] = 0.0;
            this.maxVDiv[rangeV - 1] = vStop;
        }
    }

    private void setupAOBrightnessLerp(double left, double right, double top, double bottom, int rangeLR, int rangeTB) {
        double diffLR = right - left;
        double diffTB = bottom - top;
        double posLR = 0.0;
        for (int lr = 0; lr <= rangeLR; ++lr) {
            float lerpLR = (float)(posLR / diffLR);
            int brightTop = RenderHelperAO.mixAOBrightness(this.state.brightnessTopLeft, this.state.brightnessTopRight, 1.0f - lerpLR, lerpLR);
            int brightBottom = RenderHelperAO.mixAOBrightness(this.state.brightnessBottomLeft, this.state.brightnessBottomRight, 1.0f - lerpLR, lerpLR);
            double posTB = 0.0;
            for (int tb = 0; tb <= rangeTB; ++tb) {
                float lerpTB = (float)(posTB / diffTB);
                this.brightnessLerp[lr][tb] = RenderHelperAO.mixAOBrightness(brightTop, brightBottom, 1.0f - lerpTB, lerpTB);
                if (tb >= rangeTB) continue;
                posTB += this.maxVDiv[tb] - this.minVDiv[tb];
            }
            if (lr >= rangeLR) continue;
            posLR += this.maxUDiv[lr] - this.minUDiv[lr];
        }
    }

    private void setUV(IIcon icon, double uMin, double uMax, double vMin, double vMax) {
        this.uv[0] = icon.getInterpolatedU(uMin * 16.0);
        this.uv[1] = icon.getInterpolatedU(uMax * 16.0);
        this.uv[2] = icon.getInterpolatedV(vMin * 16.0);
        this.uv[3] = icon.getInterpolatedV(vMax * 16.0);
    }

    private void setUV(double uMin, double uMax, double vMin, double vMax) {
        this.uv[0] = uMin;
        this.uv[1] = uMax;
        this.uv[2] = vMin;
        this.uv[3] = vMax;
    }

    private void setXYZ(double x, double y, double z) {
        this.xyz[0] = x + this.state.renderOffsetX + this.state.renderMinX;
        this.xyz[1] = x + this.state.renderOffsetX + this.state.renderMaxX;
        this.xyz[2] = y + this.state.renderOffsetY + this.state.renderMinY;
        this.xyz[3] = y + this.state.renderOffsetY + this.state.renderMaxY;
        this.xyz[4] = z + this.state.renderOffsetZ + this.state.renderMinZ;
        this.xyz[5] = z + this.state.renderOffsetZ + this.state.renderMaxZ;
    }

    private void renderXYZUV(int[][] index, int uvRotate) {
        Tessellator tessellator = Tessellator.instance;
        int[] tl = index[0];
        int[] bl = index[1];
        int[] br = index[2];
        int[] tr = index[3];
        double ubl = this.uv[bl[3]];
        double vbl = this.uv[bl[4]];
        double utr = this.uv[tr[3]];
        double vtr = this.uv[tr[4]];
        if (uvRotate == 1 || uvRotate == 3) {
            ubl = this.uv[tr[3]];
            vbl = this.uv[tr[4]];
            utr = this.uv[bl[3]];
            vtr = this.uv[bl[4]];
        }
        tessellator.addVertexWithUV(this.xyz[tl[0]], this.xyz[tl[1]], this.xyz[tl[2]], this.uv[tl[3]], this.uv[tl[4]]);
        tessellator.addVertexWithUV(this.xyz[bl[0]], this.xyz[bl[1]], this.xyz[bl[2]], ubl, vbl);
        tessellator.addVertexWithUV(this.xyz[br[0]], this.xyz[br[1]], this.xyz[br[2]], this.uv[br[3]], this.uv[br[4]]);
        tessellator.addVertexWithUV(this.xyz[tr[0]], this.xyz[tr[1]], this.xyz[tr[2]], utr, vtr);
    }

    private void renderXYZUVAO(int[][] index, int uvRotate) {
        Tessellator tessellator = Tessellator.instance;
        int[] tl = index[0];
        int[] bl = index[1];
        int[] br = index[2];
        int[] tr = index[3];
        double ubl = this.uv[bl[3]];
        double vbl = this.uv[bl[4]];
        double utr = this.uv[tr[3]];
        double vtr = this.uv[tr[4]];
        if (uvRotate == 1 || uvRotate == 3) {
            ubl = this.uv[tr[3]];
            vbl = this.uv[tr[4]];
            utr = this.uv[bl[3]];
            vtr = this.uv[bl[4]];
        }
        tessellator.setColorOpaque_F(this.state.colorTopLeft[0], this.state.colorTopLeft[1], this.state.colorTopLeft[2]);
        tessellator.setBrightness(this.state.brightnessTopLeft);
        tessellator.addVertexWithUV(this.xyz[tl[0]], this.xyz[tl[1]], this.xyz[tl[2]], this.uv[tl[3]], this.uv[tl[4]]);
        tessellator.setColorOpaque_F(this.state.colorBottomLeft[0], this.state.colorBottomLeft[1], this.state.colorBottomLeft[2]);
        tessellator.setBrightness(this.state.brightnessBottomLeft);
        tessellator.addVertexWithUV(this.xyz[bl[0]], this.xyz[bl[1]], this.xyz[bl[2]], ubl, vbl);
        tessellator.setColorOpaque_F(this.state.colorBottomRight[0], this.state.colorBottomRight[1], this.state.colorBottomRight[2]);
        tessellator.setBrightness(this.state.brightnessBottomRight);
        tessellator.addVertexWithUV(this.xyz[br[0]], this.xyz[br[1]], this.xyz[br[2]], this.uv[br[3]], this.uv[br[4]]);
        tessellator.setColorOpaque_F(this.state.colorTopRight[0], this.state.colorTopRight[1], this.state.colorTopRight[2]);
        tessellator.setBrightness(this.state.brightnessTopRight);
        tessellator.addVertexWithUV(this.xyz[tr[0]], this.xyz[tr[1]], this.xyz[tr[2]], utr, vtr);
    }
}

