package com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation;

import net.minecraft.item.ItemStack;

import com.dynious.refinedrelocation.api.filter.IFilter;
import com.dynious.refinedrelocation.api.tileentity.ISortingInventory;
import com.dynious.refinedrelocation.api.tileentity.ISpecialSortingInventory;
import com.dynious.refinedrelocation.api.tileentity.grid.SpecialLocalizedStack;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingInventoryHandler;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;

public class TileSortingDrawersComp extends TileEntityDrawersComp implements ISpecialSortingInventory {

    private DrawerSortingInventory sortingInventory;

    public TileSortingDrawersComp() {
        sortingInventory = new DrawerSortingInventory(this, this, this, this);
    }

    @Override
    public boolean isSorting() {
        return true;
    }

    @Override
    public boolean canUpdate() {
        return super.canUpdate() || !sortingInventory.isAttached();
    }

    @Override
    public void updateEntity() {
        if (!sortingInventory.isAttached()) sortingInventory.attach();
        super.updateEntity();
    }

    @Override
    public void invalidate() {
        sortingInventory.detach();
        super.invalidate();
    }

    @Override
    public void onChunkUnload() {
        sortingInventory.detach();
        super.onChunkUnload();
    }

    @Override
    public void markDirty() {
        super.markDirty();
        sortingInventory.markDirty();
    }

    @Override
    public boolean putStackInSlot(ItemStack itemStack, int slotIndex) {
        return sortingInventory.putStackInSlot(itemStack, slotIndex);
    }

    @Override
    public ItemStack putInInventory(ItemStack itemStack, boolean simulate) {
        return sortingInventory.putInInventory(itemStack, simulate);
    }

    @Override
    public SpecialLocalizedStack getLocalizedStackInSlot(int slot) {
        return sortingInventory.getLocalizedStackInSlot(slot);
    }

    @Override
    public void alterStackSize(int slot, int alteration) {
        sortingInventory.alterStackSize(slot, alteration);
    }

    @Override
    public ISortingInventory.Priority getPriority() {
        return sortingInventory.getPriority();
    }

    @Override
    public void setPriority(ISortingInventory.Priority priority) {
        sortingInventory.setPriority(priority);
    }

    @Override
    public IFilter getFilter() {
        return sortingInventory.getFilter();
    }

    @Override
    public ISortingInventoryHandler getHandler() {
        return sortingInventory.getHandler();
    }
}
