/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemCustomDrawers
extends ItemDrawers {
    public ItemCustomDrawers(Block block) {
        super(block);
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            return false;
        }
        TileEntityDrawers tile = (TileEntityDrawers)world.func_147438_o(x, y, z);
        if (tile != null && stack.func_77942_o() && !stack.func_77978_p().func_74764_b("tile")) {
            if (stack.func_77978_p().func_74764_b("MatS")) {
                tile.setMaterialSide(ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("MatS")));
            }
            if (stack.func_77978_p().func_74764_b("MatT")) {
                tile.setMaterialTrim(ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("MatT")));
            }
            if (stack.func_77978_p().func_74764_b("MatF")) {
                tile.setMaterialFront(ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("MatF")));
            }
        }
        return true;
    }

    public static ItemStack makeItemStack(Block block, int count, ItemStack matSide, ItemStack matTrim, ItemStack matFront) {
        Item item = Item.func_150898_a((Block)block);
        if (!(item instanceof ItemCustomDrawers)) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (matSide != null) {
            tag.func_74782_a("MatS", (NBTBase)ItemCustomDrawers.getMaterialTag(matSide));
        }
        if (matTrim != null) {
            tag.func_74782_a("MatT", (NBTBase)ItemCustomDrawers.getMaterialTag(matTrim));
        }
        if (matFront != null) {
            tag.func_74782_a("MatF", (NBTBase)ItemCustomDrawers.getMaterialTag(matFront));
        }
        ItemStack stack = new ItemStack(item, count, 0);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    @Override
    protected void addAlternativeTagInformation(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        this.addDescriptionInformation(this.getCapacityForBlock(block), list);
        this.addMaterialsInformation(itemStack.func_77978_p(), list);
    }

    @Override
    protected void addNoneTagDescriptionInformation(int drawerCapacity, List list) {
        super.addNoneTagDescriptionInformation(drawerCapacity, list);
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialList"));
        list.add("  " + EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialNone"));
    }

    @Override
    protected void addSealedContentsInformation(NBTTagCompound tag, List list) {
        this.addMaterialsInformation(tag, list);
    }

    private void addMaterialsInformation(NBTTagCompound tag, List list) {
        ItemStack materialSide = null;
        ItemStack materialFront = null;
        ItemStack materialTrim = null;
        boolean hasMaterials = false;
        if (tag.func_74764_b("MatS")) {
            materialSide = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatS"));
            hasMaterials = true;
        }
        if (tag.func_74764_b("MatF")) {
            materialFront = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatF"));
            hasMaterials = true;
        }
        if (tag.func_74764_b("MatT")) {
            materialTrim = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatT"));
            hasMaterials = true;
        }
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialList"));
        if (hasMaterials) {
            list.add("  " + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialSide") + " " + this.getMaterialDisplayName(materialSide));
            list.add("  " + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialTrim") + " " + this.getMaterialDisplayName(materialTrim));
            list.add("  " + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialFront") + " " + this.getMaterialDisplayName(materialFront));
        } else {
            list.add("  " + EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialNone"));
        }
    }

    private String getMaterialDisplayName(ItemStack stack) {
        if (stack != null) {
            return this.getGoodDisplayName(stack);
        }
        return EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialNone");
    }

    private static NBTTagCompound getMaterialTag(ItemStack mat) {
        mat = mat.func_77946_l();
        mat.field_77994_a = 1;
        NBTTagCompound itag = new NBTTagCompound();
        mat.func_77955_b(itag);
        return itag;
    }
}

