/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCompDrawers
extends BlockDrawers
implements INetworked {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconFront;
    @SideOnly(value=Side.CLIENT)
    private IIcon[][] iconFrontInd;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTrim;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSideEtched;

    public BlockCompDrawers(String blockName) {
        super(Material.rock, blockName, 3, false);
        this.setStepSound(Block.soundTypeStone);
    }

    @Override
    protected int getDrawerSlot(int side, float hitX, float hitY, float hitZ) {
        if (this.hitTop(hitY)) {
            return 0;
        }
        if (this.hitLeft(side, hitX, hitZ)) {
            return 1;
        }
        return 2;
    }

    @Override
    public BlockType retrimType() {
        return null;
    }

    @Override
    public TileEntityDrawers createNewTileEntity(World world, int meta) {
        return new TileEntityDrawersComp();
    }

    @Override
    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTrim(int meta) {
        return this.iconTrim;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        switch (side) {
            case 0: 
            case 1: {
                return this.iconSide;
            }
            case 4: {
                return this.iconFront[0];
            }
        }
        return this.iconSideEtched;
    }

    @Override
    public IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityDrawers tile = BlockCompDrawers.getTileEntity(blockAccess, x, y, z);
        if (tile == null) {
            return this.iconFront[0];
        }
        if (side == tile.getDirection()) {
            if (tile.getEffectiveStatusLevel() == 0) {
                if (tile.isDrawerEnabled(2) && tile.getDrawer(2).getStoredItemStackSize() > 0) {
                    return this.iconFront[2];
                }
                if (tile.isDrawerEnabled(1) && tile.getDrawer(1).getStoredItemStackSize() > 0) {
                    return this.iconFront[1];
                }
                return this.iconFront[0];
            }
            IDrawer main = tile.getDrawer(0);
            int plev = 0;
            if (tile.getEffectiveStatusLevel() == 1) {
                plev = main.getMaxCapacity() > 0 && main.getRemainingCapacity() == 0 ? 6 : 0;
            } else if (main.getMaxCapacity() > 0) {
                float pfull = (float)main.getStoredItemCount() / (float)main.getMaxCapacity();
                plev = MathHelper.clamp_int((int)((int)((double)pfull * 6.99)), (int)0, (int)6);
            }
            if (tile.isDrawerEnabled(2) && tile.getDrawer(2).getStoredItemStackSize() > 0) {
                return this.iconFrontInd[2][plev];
            }
            if (tile.isDrawerEnabled(1) && tile.getDrawer(1).getStoredItemStackSize() > 0) {
                return this.iconFrontInd[1][plev];
            }
            return this.iconFrontInd[0][plev];
        }
        switch (side) {
            case 0: 
            case 1: {
                return this.iconSide;
            }
        }
        return this.iconSideEtched;
    }

    @Override
    public void registerBlockIcons(IIconRegister register) {
        super.registerBlockIcons(register);
        this.iconFront = new IIcon[3];
        this.iconFrontInd = new IIcon[3][7];
        for (int i = 0; i < 3; ++i) {
            this.iconFront[i] = register.registerIcon("StorageDrawers:drawers_comp_front_" + i);
            this.iconFrontInd[i][0] = register.registerIcon("StorageDrawers:drawers_comp_front_" + i + "_ind");
            for (int j = 1; j <= 6; ++j) {
                this.iconFrontInd[i][j] = register.registerIcon("StorageDrawers:drawers_comp_front_" + i + "_ind" + j);
            }
        }
        this.iconTrim = register.registerIcon("StorageDrawers:drawers_comp_trim");
        this.iconSide = register.registerIcon("StorageDrawers:drawers_comp_side");
        this.iconSideEtched = register.registerIcon("StorageDrawers:drawers_comp_side_2");
    }
}

