/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.pack;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackBlock;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackDataResolver;
import com.jaquadro.minecraft.storagedrawers.api.pack.TextureType;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BlockDrawersPack
extends BlockDrawers
implements IPackBlock {
    private IPackDataResolver resolver;

    public BlockDrawersPack(IPackDataResolver resolver, int drawerCount, boolean halfDepth) {
        super(resolver.getBlockName(BlockConfiguration.by(BlockType.Drawers, drawerCount, halfDepth)), drawerCount, halfDepth);
        this.resolver = resolver;
        CreativeTabs tabs = resolver.getCreativeTabs(BlockType.Drawers);
        if (StorageDrawers.config.cache.addonSeparateVanilla && tabs != null) {
            this.setCreativeTab(tabs);
        } else {
            this.setCreativeTab(ModCreativeTabs.tabStorageDrawers);
        }
    }

    public String[] getUnlocalizedNames() {
        String[] names = new String[16];
        for (int i = 0; i < 16; ++i) {
            if (!this.resolver.isValidMetaValue(i)) continue;
            names[i] = this.resolver.getUnlocalizedName(i);
        }
        return names;
    }

    @Override
    public IPackDataResolver getDataResolver() {
        return this.resolver;
    }

    @Override
    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List list) {
        if (!StorageDrawers.config.cache.addonShowVanilla) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            if (!this.resolver.isValidMetaValue(i)) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        int n = meta = meta < 0 || meta >= this.iconSide.length ? 0 : meta;
        if (!this.resolver.isValidMetaValue(meta)) {
            this.getSimilarBlock().getIcon(side, meta);
        }
        return super.getIcon(side, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int level) {
        int meta = blockAccess.getBlockMetadata(x, y, z);
        int n = meta = meta < 0 || meta >= this.iconSide.length ? 0 : meta;
        if (!this.resolver.isValidMetaValue(meta)) {
            this.getSimilarBlock().getIcon(side, meta);
        }
        return super.getIcon(blockAccess, x, y, z, side, level);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTrim(int meta) {
        int n = meta = meta < 0 || meta >= this.iconSide.length ? 0 : meta;
        if (!this.resolver.isValidMetaValue(meta)) {
            this.getSimilarBlock().getIconTrim(meta);
        }
        return super.getIconTrim(meta);
    }

    private BlockDrawers getSimilarBlock() {
        if (this.drawerCount == 1 && !this.halfDepth) {
            return ModBlocks.fullDrawers1;
        }
        if (this.drawerCount == 2 && !this.halfDepth) {
            return ModBlocks.fullDrawers2;
        }
        if (this.drawerCount == 4 && !this.halfDepth) {
            return ModBlocks.fullDrawers4;
        }
        if (this.drawerCount == 2 && this.halfDepth) {
            return ModBlocks.halfDrawers2;
        }
        if (this.drawerCount == 4 && this.halfDepth) {
            return ModBlocks.halfDrawers4;
        }
        return ModBlocks.fullDrawers1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        super.registerBlockIcons(register);
        this.iconSide = new IIcon[16];
        this.iconSideH = new IIcon[16];
        this.iconSideV = new IIcon[16];
        this.iconFront1 = new IIcon[16];
        this.iconFront2 = new IIcon[16];
        this.iconFront4 = new IIcon[16];
        this.iconTrim = new IIcon[16];
        for (int i = 0; i < 16; ++i) {
            if (!this.resolver.isValidMetaValue(i)) continue;
            this.iconFront1[i] = register.registerIcon(this.resolver.getTexturePath(TextureType.Front1, i));
            this.iconFront2[i] = register.registerIcon(this.resolver.getTexturePath(TextureType.Front2, i));
            this.iconFront4[i] = register.registerIcon(this.resolver.getTexturePath(TextureType.Front4, i));
            this.iconSide[i] = register.registerIcon(this.resolver.getTexturePath(TextureType.Side, i));
            this.iconSideV[i] = register.registerIcon(this.resolver.getTexturePath(TextureType.SideVSplit, i));
            this.iconSideH[i] = register.registerIcon(this.resolver.getTexturePath(TextureType.SideHSplit, i));
            this.iconTrim[i] = register.registerIcon(this.resolver.getTexturePath(TextureType.TrimBorder, i));
        }
    }
}

