/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import cpw.mods.fml.common.FMLLog;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.apache.logging.log4j.Level;

public class BaseTileEntity
extends TileEntity {
    private NBTTagCompound failureSnapshot;

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.failureSnapshot = null;
        try {
            this.readFromFixedNBT(tag);
            this.readFromPortableNBT(tag);
        }
        catch (Throwable t) {
            this.trapLoadFailure(t, tag);
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        if (this.failureSnapshot != null) {
            this.restoreLoadFailure(tag);
            return;
        }
        try {
            this.writeToFixedNBT(tag);
            this.writeToPortableNBT(tag);
        }
        catch (Throwable t) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.ERROR, (Throwable)t, (String)"Tile Save Failure.", (Object[])new Object[0]);
        }
    }

    public void readFromPortableNBT(NBTTagCompound tag) {
    }

    public void writeToPortableNBT(NBTTagCompound tag) {
    }

    protected void readFromFixedNBT(NBTTagCompound tag) {
    }

    protected void writeToFixedNBT(NBTTagCompound tag) {
    }

    protected void trapLoadFailure(Throwable t, NBTTagCompound tag) {
        this.failureSnapshot = (NBTTagCompound)tag.copy();
        FMLLog.log((String)"StorageDrawers", (Level)Level.ERROR, (Throwable)t, (String)"Tile Load Failure.", (Object[])new Object[0]);
    }

    protected void restoreLoadFailure(NBTTagCompound tag) {
        for (String key : this.failureSnapshot.func_150296_c()) {
            if (tag.hasKey(key)) continue;
            tag.setTag(key, this.failureSnapshot.getTag(key).copy());
        }
    }

    protected boolean loadDidFail() {
        return this.failureSnapshot != null;
    }
}

