/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.render.IRenderLabel;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.util.CountFormatter;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityDrawersRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private final RenderItem itemRenderer = new RenderItem(){
        private final RenderBlocks renderBlocksRi = new RenderBlocks();

        public byte getMiniBlockCount(ItemStack stack, byte original) {
            return 1;
        }

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }

        public void renderItemIntoGUI(FontRenderer fontRenderer, TextureManager texManager, ItemStack itemStack, int x, int y, boolean renderEffect) {
            if (itemStack.getItemSpriteNumber() == 0 && RenderBlocks.renderItemIn3d((int)Block.getBlockFromItem((Item)itemStack.getItem()).getRenderType())) {
                this.renderItemIntoGUIBlock(fontRenderer, texManager, itemStack, x, y, renderEffect);
                return;
            }
            Item item = itemStack.getItem();
            int meta = itemStack.getItemDamage();
            ResourceLocation loc = itemStack.getItem().requiresMultipleRenderPasses() ? (item.getSpriteNumber() == 0 ? TextureMap.locationBlocksTexture : TextureMap.locationItemsTexture) : texManager.getResourceLocation(itemStack.getItemSpriteNumber());
            for (int i = 0; i < item.getRenderPasses(meta); ++i) {
                IIcon icon;
                OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
                texManager.bindTexture(loc);
                IIcon iIcon = icon = itemStack.getItem().requiresMultipleRenderPasses() ? item.getIcon(itemStack, i) : itemStack.getIconIndex();
                if (icon == null) continue;
                int color = itemStack.getItem().getColorFromItemStack(itemStack, i);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                if (this.renderWithColor) {
                    GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
                }
                GL11.glEnable((int)32823);
                GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                GL11.glEnable((int)3008);
                this.renderIcon(x, y, icon, 16, 16);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                if (renderEffect && itemStack.hasEffect(i)) {
                    this.renderEffect(texManager, x, y);
                }
                GL11.glDisable((int)32823);
            }
        }

        public void renderEffect(TextureManager manager, int x, int y) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            manager.bindTexture(RES_ITEM_GLINT);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)0.5f, (float)0.25f, (float)0.8f, (float)1.0f);
            this.renderGlint(x, y, 16, 16);
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }

        private void renderGlint(int x, int y, int w, int h) {
            for (int i = 0; i < 2; ++i) {
                OpenGlHelper.glBlendFunc((int)772, (int)1, (int)0, (int)0);
                float uScale = 0.00390625f;
                float vScale = 0.00390625f;
                float u = (float)(Minecraft.getSystemTime() % (long)(3000 + i * 1873)) / (3000.0f + (float)(i * 1873)) * 256.0f;
                float v = 0.0f;
                float hScale = i < 1 ? 4.0f : -1.0f;
                Tessellator tessellator = Tessellator.instance;
                tessellator.startDrawingQuads();
                tessellator.addVertexWithUV((double)(x + 0), (double)(y + h), 0.0, (double)((u + (float)h * hScale) * uScale), (double)((v + (float)h) * vScale));
                tessellator.addVertexWithUV((double)(x + w), (double)(y + h), 0.0, (double)((u + (float)w + (float)h * hScale) * uScale), (double)((v + (float)h) * vScale));
                tessellator.addVertexWithUV((double)(x + w), (double)(y + 0), 0.0, (double)((u + (float)w) * uScale), (double)((v + 0.0f) * vScale));
                tessellator.addVertexWithUV((double)(x + 0), (double)(y + 0), 0.0, (double)((u + 0.0f) * uScale), (double)((v + 0.0f) * vScale));
                tessellator.draw();
            }
        }

        private void renderItemIntoGUIBlock(FontRenderer fontRenderer, TextureManager texManager, ItemStack itemStack, int x, int y, boolean renderEffect) {
            texManager.bindTexture(TextureMap.locationBlocksTexture);
            Block block = Block.getBlockFromItem((Item)itemStack.getItem());
            if (block.getRenderBlockPass() != 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glEnable((int)3042);
                OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
            } else {
                GL11.glAlphaFunc((int)516, (float)0.5f);
                GL11.glDisable((int)3042);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x - 2), (float)(y + 3), (float)(this.zLevel - 3.0f));
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int color = itemStack.getItem().getColorFromItemStack(itemStack, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            if (this.renderWithColor) {
                GL11.glColor4f((float)(r * 1.0f), (float)(g * 1.0f), (float)(b * 1.0f), (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)32823);
            GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
            this.renderBlocksRi.useInventoryTint = this.renderWithColor;
            this.renderBlocksRi.renderBlockAsItem(block, itemStack.getItemDamage(), 1.0f);
            this.renderBlocksRi.useInventoryTint = true;
            GL11.glDisable((int)32823);
            if (block.getRenderBlockPass() == 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
            }
            GL11.glPopMatrix();
        }
    };
    private final float[] itemOffset2X = new float[]{0.5f, 0.5f};
    private final float[] itemOffset2Y = new float[]{10.25f, 2.25f};
    private final float[] itemOffset4X = new float[]{0.25f, 0.25f, 0.75f, 0.75f};
    private final float[] itemOffset4Y = new float[]{10.25f, 2.25f, 10.25f, 2.25f};
    private final float[] itemOffset3X = new float[]{0.5f, 0.25f, 0.75f};
    private final float[] itemOffset3Y = new float[]{9.75f, 2.25f, 2.25f};
    private final RenderBlocks renderBlocks = new RenderBlocks();
    private float brightness;
    private static final float unit = 0.0625f;
    private final boolean[] renderAsBlock = new boolean[4];
    private final ItemStack[] renderStacks = new ItemStack[4];
    private static final float[] sideRotationY = new float[]{0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 3.0f};
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f};
    private static final float[] offsetX = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};

    public void renderTileEntityAt(TileEntity tile, double x, double y, double z, float partialTickTime) {
        TileEntityDrawers tileDrawers = (TileEntityDrawers)tile;
        if (tileDrawers == null) {
            return;
        }
        if (tileDrawers.isShrouded() || tileDrawers.isSealed()) {
            return;
        }
        Block block = tile.getWorldObj().getBlock(tile.xCoord, tile.yCoord, tile.zCoord);
        if (!(block instanceof BlockDrawers)) {
            return;
        }
        float depth = ((BlockDrawers)block).halfDepth ? 0.5f : 1.0f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        this.itemRenderer.setRenderManager(RenderManager.instance);
        ForgeDirection side = ForgeDirection.getOrientation((int)tileDrawers.getDirection());
        int ambLight = tile.getWorldObj().getLightBrightnessForSkyBlocks(tile.xCoord + side.offsetX, tile.yCoord + side.offsetY, tile.zCoord + side.offsetZ, 0);
        int lu = ambLight % 65536;
        int lv = ambLight / 65536;
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)lu, (float)lv);
        this.brightness = tile.getWorldObj().getLightBrightness(tile.xCoord + side.offsetX, tile.yCoord + side.offsetY, tile.zCoord + side.offsetZ) * 1.25f;
        if (this.brightness > 1.0f) {
            this.brightness = 1.0f;
        }
        Minecraft mc = Minecraft.getMinecraft();
        boolean cache = mc.gameSettings.fancyGraphics;
        mc.gameSettings.fancyGraphics = true;
        try {
            if (StorageDrawers.config.isFancyItemRenderEnabled()) {
                this.renderFancyItemSet(tileDrawers, side, depth);
            } else {
                this.renderFastItemSet(tileDrawers, side, depth, partialTickTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StorageDrawers.config.cache.enableQuantifyUpgrades && tileDrawers.isQuantified()) {
            EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
            double dx = (double)tile.xCoord + 0.5 - player.posX;
            double dy = (double)tile.yCoord + 0.5 - player.posY;
            double dz = (double)tile.zCoord + 0.5 - player.posZ;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            float alpha = 1.0f;
            if (distance > 4.0) {
                alpha = Math.max(1.0f - (float)((distance - 4.0) / 6.0), 0.05f);
            }
            if (distance < 10.0) {
                for (int i = 0; i < tileDrawers.getDrawerCount(); ++i) {
                    if (!tileDrawers.isDrawerEnabled(i)) continue;
                    this.drawDrawerTexts(tileDrawers, i, side, depth, alpha);
                }
            }
        }
        mc.gameSettings.fancyGraphics = cache;
        GL11.glPopMatrix();
    }

    private void renderFancyItemSet(TileEntityDrawers tile, ForgeDirection side, float depth) {
        boolean restoreGLState = false;
        boolean isLightingEnabled = false;
        boolean isBlendEnabled = false;
        int drawerCount = tile.getDrawerCount();
        for (int i = 0; i < drawerCount; ++i) {
            IDrawer drawer;
            ItemStack itemStack;
            if (!tile.isDrawerEnabled(i) || (itemStack = (drawer = tile.getDrawer(i)).getStoredItemPrototype()) == null) continue;
            if (!restoreGLState) {
                restoreGLState = true;
                isLightingEnabled = GL11.glIsEnabled((int)2896);
                isBlendEnabled = GL11.glIsEnabled((int)3042);
            }
            this.renderFancyItem(itemStack, tile, i, side, depth);
        }
        if (restoreGLState) {
            if (isLightingEnabled) {
                GL11.glEnable((int)2896);
            } else {
                GL11.glDisable((int)2896);
            }
            if (isBlendEnabled) {
                GL11.glEnable((int)3042);
            } else {
                GL11.glDisable((int)3042);
            }
        }
    }

    private void renderFastItemSet(TileEntityDrawers tile, ForgeDirection side, float depth, float partialTickTime) {
        int i;
        int drawerCount = tile.getDrawerCount();
        boolean restoreItemState = false;
        boolean restoreBlockState = false;
        for (i = 0; i < drawerCount; ++i) {
            IDrawer drawer;
            ItemStack itemStack;
            this.renderStacks[i] = null;
            if (!tile.isDrawerEnabled(i) || (itemStack = (drawer = tile.getDrawer(i)).getStoredItemPrototype()) == null) continue;
            this.renderStacks[i] = itemStack;
            this.renderAsBlock[i] = this.isItemBlockType(itemStack);
            if (this.renderAsBlock[i]) {
                restoreBlockState = true;
                continue;
            }
            restoreItemState = true;
        }
        if (restoreItemState || restoreBlockState) {
            GL11.glPushAttrib((int)24640);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i] == null || this.renderAsBlock[i]) continue;
            this.renderFastItem(this.renderStacks[i], tile, i, side, depth, partialTickTime);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i] == null || !this.renderAsBlock[i]) continue;
            this.renderFastItem(this.renderStacks[i], tile, i, side, depth, partialTickTime);
        }
        if (restoreItemState || restoreBlockState) {
            GL11.glPopAttrib();
        }
    }

    private void drawDrawerTexts(TileEntityDrawers tile, int slot, ForgeDirection side, float depth, float alpha) {
        BlockDrawers block = (BlockDrawers)tile.getBlockType();
        int drawerCount = tile.getDrawerCount();
        float offsetX = 8.0f;
        float offsetY = 14.0f;
        block0 : switch (drawerCount) {
            case 1: {
                break;
            }
            case 2: {
                offsetY = slot == 0 ? 6.0f : 14.0f;
                break;
            }
            case 3: {
                switch (slot) {
                    case 0: {
                        offsetY = 7.0f;
                        break;
                    }
                    case 1: {
                        offsetX = 4.0f;
                        break;
                    }
                    case 2: {
                        offsetX = 12.0f;
                    }
                }
                break;
            }
            case 4: {
                switch (slot) {
                    case 0: {
                        offsetX = 4.0f;
                        offsetY = 6.0f;
                        break block0;
                    }
                    case 1: {
                        offsetX = 4.0f;
                        break block0;
                    }
                    case 2: {
                        offsetX = 12.0f;
                        offsetY = 6.0f;
                        break block0;
                    }
                    case 3: {
                        offsetX = 12.0f;
                    }
                }
            }
        }
        this.renderText(CountFormatter.format(this.func_147498_b(), tile.getDrawer(slot)), side, offsetX, offsetY, 1.0f - depth + block.getTrimDepth() - 0.005f, alpha);
    }

    private void renderText(String renderString, ForgeDirection side, float offsetX, float offsetY, float offsetZ, float alpha) {
        int stringWidth = this.func_147498_b().getStringWidth(renderString);
        GL11.glPushMatrix();
        this.alignRendering(side);
        this.moveRendering(0.125f, offsetX, offsetY, offsetZ);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_147498_b().drawString(renderString, -stringWidth / 2, 0, (int)(255.0f * alpha) << 24 | 0xFF0000 | 0xFF00 | 0xFF);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void renderFancyItem(ItemStack itemStack, TileEntityDrawers tile, int slot, ForgeDirection side, float depth) {
        float relScale;
        int drawerCount = tile.getDrawerCount();
        boolean isBlockType = this.isItemBlockType(itemStack);
        BlockDrawers block = (BlockDrawers)tile.getBlockType();
        float xunit = this.getXOffset(drawerCount, slot);
        float yunit = this.getYOffset(drawerCount, slot);
        float zunit = isBlockType ? 1.95f * block.getTrimDepth() : block.getTrimDepth();
        float xc = 0.0f;
        float zc = 0.0f;
        float itemDepth = depth + 0.001f;
        float f = relScale = tile.getDrawerCount() == 1 ? 2.0f : 1.0f;
        if (isBlockType) {
            try {
                Block itemBlock = Block.getBlockFromItem((Item)itemStack.getItem());
                itemBlock.setBlockBoundsBasedOnState((IBlockAccess)tile.getWorldObj(), 0, 0, 0);
                itemBlock.setBlockBoundsForItemRender();
                double zDepth = (double)(1.0f / relScale) - itemBlock.getBlockBoundsMaxZ();
                itemDepth = (float)((double)itemDepth + zDepth * (double)zunit);
            }
            catch (Exception itemBlock) {
                // empty catch block
            }
        }
        switch (tile.getDirection()) {
            case 3: {
                xc = xunit;
                zc = itemDepth - zunit;
                break;
            }
            case 2: {
                xc = 1.0f - xunit;
                zc = 1.0f - itemDepth + zunit;
                break;
            }
            case 5: {
                xc = itemDepth - zunit;
                zc = 1.0f - xunit;
                break;
            }
            case 4: {
                xc = 1.0f - itemDepth + zunit;
                zc = xunit;
            }
        }
        float yAdj = 0.0f;
        if (drawerCount == 2 || drawerCount == 4) {
            yAdj = -0.5f;
        } else if (drawerCount == 1) {
            yAdj = -3.0f;
        }
        GL11.glPushMatrix();
        if (isBlockType) {
            GL11.glTranslatef((float)xc, (float)(0.0625f * (yunit + 1.75f + yAdj)), (float)zc);
            GL11.glScalef((float)(1.0f * relScale), (float)(1.0f * relScale), (float)(1.0f * relScale));
            GL11.glRotatef((float)(this.getRotationYForSide(side) + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)xc, (float)(0.0625f * (yunit + 0.75f + yAdj)), (float)zc);
            GL11.glScalef((float)(0.5f * relScale), (float)(0.5f * relScale), (float)(0.5f * relScale));
            GL11.glRotatef((float)this.getRotationYForSide(side), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        IDrawer drawer = tile.getDrawer(slot);
        try {
            EntityItem itemEnt = drawer.getEntityItemForRender(itemStack);
            this.itemRenderer.doRender(itemEnt, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glPopMatrix();
    }

    private void renderFastItem(ItemStack itemStack, TileEntityDrawers tile, int slot, ForgeDirection side, float depth, float partialTickTime) {
        String itemBlockName;
        boolean skipRenderHook = false;
        Block itemBlock = Block.getBlockFromItem((Item)itemStack.getItem());
        if (itemBlock != null && (itemBlockName = GameData.getBlockRegistry().getNameForObject((Object)itemBlock)) != null && itemBlockName.equals("Mariculture:tanks")) {
            skipRenderHook = true;
        }
        Minecraft mc = Minecraft.getMinecraft();
        int drawerCount = tile.getDrawerCount();
        float xunit = this.getXOffset(drawerCount, slot);
        float yunit = this.getYOffset(drawerCount, slot);
        float size = drawerCount == 1 ? 0.5f : 0.25f;
        BlockDrawers block = (BlockDrawers)tile.getBlockType();
        GL11.glPushMatrix();
        this.alignRendering(side);
        this.moveRendering(size, this.getOffsetXForSide(side, xunit) * 16.0f - 8.0f * size, 12.25f - yunit, 1.0f - depth + block.getTrimDepth() - 0.005f);
        List<IRenderLabel> renderHandlers = StorageDrawers.renderRegistry.getRenderHandlers();
        int n = renderHandlers.size();
        for (int i = 0; i < n; ++i) {
            renderHandlers.get(i).render(tile, tile, slot, this.brightness, partialTickTime);
        }
        GL11.glPushMatrix();
        if (drawerCount == 1) {
            GL11.glScalef((float)2.6f, (float)2.6f, (float)1.0f);
            GL11.glRotatef((float)171.6f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)84.9f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glScalef((float)1.92f, (float)1.92f, (float)1.0f);
            GL11.glRotatef((float)169.2f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)79.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        RenderHelper.enableStandardItemLighting();
        GL11.glPopMatrix();
        GL11.glEnable((int)3008);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2977);
        try {
            if (skipRenderHook || !ForgeHooksClient.renderInventoryItem((RenderBlocks)this.renderBlocks, (TextureManager)mc.renderEngine, (ItemStack)itemStack, (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f)) {
                this.itemRenderer.renderItemIntoGUI(mc.fontRenderer, mc.renderEngine, itemStack, 0, 0, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glPopMatrix();
    }

    private boolean isItemBlockType(ItemStack itemStack) {
        return itemStack.getItemSpriteNumber() == 0 && itemStack.getItem() instanceof ItemBlock && RenderBlocks.renderItemIn3d((int)Block.getBlockFromItem((Item)itemStack.getItem()).getRenderType());
    }

    private float getXOffset(int drawerCount, int slot) {
        switch (drawerCount) {
            case 1: {
                return 0.5f;
            }
            case 2: {
                return this.itemOffset2X[slot];
            }
            case 3: {
                return this.itemOffset3X[slot];
            }
            case 4: {
                return this.itemOffset4X[slot];
            }
        }
        return 0.0f;
    }

    private float getYOffset(int drawerCount, int slot) {
        switch (drawerCount) {
            case 1: {
                return 8.25f;
            }
            case 2: {
                return this.itemOffset2Y[slot];
            }
            case 3: {
                return this.itemOffset3Y[slot];
            }
            case 4: {
                return this.itemOffset4Y[slot];
            }
        }
        return 0.0f;
    }

    private void alignRendering(ForgeDirection side) {
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)this.getRotationYForSide2D(side), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
    }

    private void moveRendering(float size, float offsetX, float offsetY, float offsetZ) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)offsetZ);
        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)-1.0E-4f);
        GL11.glTranslatef((float)offsetX, (float)offsetY, (float)0.0f);
        GL11.glScalef((float)size, (float)size, (float)1.0f);
    }

    private float getRotationYForSide(ForgeDirection side) {
        return sideRotationY[side.ordinal()] * 90.0f;
    }

    private float getRotationYForSide2D(ForgeDirection side) {
        return sideRotationY2D[side.ordinal()] * 90.0f;
    }

    private float getOffsetXForSide(ForgeDirection side, float x) {
        return Math.abs(offsetX[side.ordinal()] - x);
    }
}

