/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.api.registry.IIngredientHandler;
import com.jaquadro.minecraft.storagedrawers.api.registry.IRecipeHandler;
import com.jaquadro.minecraft.storagedrawers.api.registry.IRecipeHandlerRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeHandlerRegistry
implements IRecipeHandlerRegistry {
    private Map<Class, IRecipeHandler> recipeRegistry = new HashMap<Class, IRecipeHandler>();
    private Map<Class, IIngredientHandler> ingredientRegistry = new HashMap<Class, IIngredientHandler>();

    public RecipeHandlerRegistry() {
        this.registerRecipeHandler(ShapedOreRecipe.class, new ShapedOreRecipeHandler());
        this.registerRecipeHandler(ShapedRecipes.class, new ShapedRecipeHandler());
        this.registerRecipeHandler(ShapelessOreRecipe.class, new ShapelessOreRecipeHandler());
        this.registerRecipeHandler(ShapelessRecipes.class, new ShapelessRecipeHandler());
    }

    @Override
    public void registerRecipeHandler(Class clazz, IRecipeHandler handler) {
        if (!this.recipeRegistry.containsKey(clazz)) {
            this.recipeRegistry.put(clazz, handler);
        }
    }

    @Override
    public void registerIngredientHandler(Class clazz, IIngredientHandler handler) {
        if (!this.ingredientRegistry.containsKey(clazz)) {
            this.ingredientRegistry.put(clazz, handler);
        }
    }

    @Override
    public IRecipeHandler getRecipeHandler(Class clazz) {
        while (clazz != null) {
            if (this.recipeRegistry.containsKey(clazz)) {
                return this.recipeRegistry.get(clazz);
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Override
    public IIngredientHandler getIngredientHandler(Class clazz) {
        while (clazz != null) {
            if (this.ingredientRegistry.containsKey(clazz)) {
                return this.ingredientRegistry.get(clazz);
            }
            for (Class<?> inter : clazz.getInterfaces()) {
                if (!this.ingredientRegistry.containsKey(inter)) continue;
                return this.ingredientRegistry.get(inter);
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static class ShapelessRecipeHandler
    implements IRecipeHandler {
        private ShapelessRecipeHandler() {
        }

        @Override
        public Object[] getInputAsArray(IRecipe recipe) {
            return null;
        }

        @Override
        public List getInputAsList(IRecipe recipe) {
            return ((ShapelessRecipes)recipe).recipeItems;
        }
    }

    private static class ShapelessOreRecipeHandler
    implements IRecipeHandler {
        private ShapelessOreRecipeHandler() {
        }

        @Override
        public Object[] getInputAsArray(IRecipe recipe) {
            return null;
        }

        @Override
        public List getInputAsList(IRecipe recipe) {
            return ((ShapelessOreRecipe)recipe).getInput();
        }
    }

    private static class ShapedRecipeHandler
    implements IRecipeHandler {
        private ShapedRecipeHandler() {
        }

        @Override
        public Object[] getInputAsArray(IRecipe recipe) {
            return ((ShapedRecipes)recipe).recipeItems;
        }

        @Override
        public List getInputAsList(IRecipe recipe) {
            return null;
        }
    }

    private static class ShapedOreRecipeHandler
    implements IRecipeHandler {
        private ShapedOreRecipeHandler() {
        }

        @Override
        public Object[] getInputAsArray(IRecipe recipe) {
            return ((ShapedOreRecipe)recipe).getInput();
        }

        @Override
        public List getInputAsList(IRecipe recipe) {
            return null;
        }
    }
}

