/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.registry.IWailaTooltipHandler;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.integration.IntegrationModule;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class Waila
extends IntegrationModule {
    @Override
    public String getModID() {
        return "Waila";
    }

    @Override
    public void init() throws Throwable {
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.jaquadro.minecraft.storagedrawers.integration.Waila.registerProvider");
    }

    @Override
    public void postInit() {
    }

    public static void registerProvider(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)new WailaDrawer(), BlockDrawers.class);
    }

    public static class WailaDrawer
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return null;
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            TileEntityDrawers tile = (TileEntityDrawers)accessor.getTileEntity();
            if (SecurityManager.hasAccess(Minecraft.getMinecraft().thePlayer.getGameProfile(), tile)) {
                for (int i = 0; i < tile.getDrawerCount(); ++i) {
                    if (!tile.isDrawerEnabled(i)) continue;
                    String name = StatCollector.translateToLocal((String)"storageDrawers.waila.empty");
                    IDrawer drawer = tile.getDrawer(i);
                    ItemStack stack = drawer.getStoredItemPrototype();
                    if (stack != null && stack.getItem() != null) {
                        String stackName = stack.getDisplayName();
                        List<IWailaTooltipHandler> handlers = StorageDrawers.wailaRegistry.getTooltipHandlers();
                        int n = handlers.size();
                        for (int j = 0; j < n; ++j) {
                            stackName = handlers.get(j).transformItemName(drawer, stackName);
                        }
                        if (drawer.getStoredItemCount() == Integer.MAX_VALUE) {
                            name = stackName + " [\u221e]";
                        } else if (drawer instanceof IFractionalDrawer && ((IFractionalDrawer)drawer).getConversionRate() > 1) {
                            name = stackName + (i == 0 ? " [" : " [+") + ((IFractionalDrawer)drawer).getStoredItemRemainder() + "]";
                        } else if (StorageDrawers.config.cache.stackRemainderWaila) {
                            int stacks = drawer.getStoredItemCount() / drawer.getStoredItemStackSize();
                            int remainder = drawer.getStoredItemCount() - stacks * drawer.getStoredItemStackSize();
                            name = stacks > 0 && remainder > 0 ? stackName + " [" + stacks + "x" + drawer.getStoredItemStackSize() + " + " + remainder + "]" : (stacks > 0 ? stackName + " [" + stacks + "x" + drawer.getStoredItemStackSize() + "]" : stackName + " [" + remainder + "]");
                        } else {
                            name = stackName + " [" + drawer.getStoredItemCount() + "]";
                        }
                    }
                    currenttip.add(StatCollector.translateToLocalFormatted((String)"storageDrawers.waila.drawer", (Object[])new Object[]{i + 1, name}));
                }
                if (tile.isUnlimited() || tile.isVending()) {
                    currenttip.add(StatCollector.translateToLocalFormatted((String)"storageDrawers.waila.nolimit", (Object[])new Object[0]));
                } else {
                    int limit = tile.getDrawerCapacity() * tile.getEffectiveStorageMultiplier();
                    currenttip.add(StatCollector.translateToLocalFormatted((String)"storageDrawers.waila.limit", (Object[])new Object[]{limit, tile.getEffectiveStorageMultiplier()}));
                }
            }
            String attrib = "";
            if (tile.isLocked(LockAttribute.LOCK_POPULATED)) {
                attrib = attrib + (attrib.isEmpty() ? "" : ", ") + StatCollector.translateToLocal((String)"storageDrawers.waila.locked");
            }
            if (tile.isVoid()) {
                attrib = attrib + (attrib.isEmpty() ? "" : ", ") + StatCollector.translateToLocal((String)"storageDrawers.waila.void");
            }
            if (tile.isSorting()) {
                attrib = attrib + (attrib.isEmpty() ? "" : ", ") + StatCollector.translateToLocal((String)"storageDrawers.waila.sorting");
            }
            if (tile.getOwner() != null) {
                attrib = attrib + (attrib.isEmpty() ? "" : ", ") + StatCollector.translateToLocal((String)"storageDrawers.waila.protected");
            }
            if (!attrib.isEmpty()) {
                currenttip.add(attrib);
            }
            return currenttip;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
            return null;
        }
    }
}

