/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation.BlockSortingCompDrawers;
import com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation.BlockSortingDrawers;
import com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation.BlockSortingTrim;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemUpgradeSorting
extends Item {
    public ItemUpgradeSorting(String name) {
        this.setUnlocalizedName(name);
        this.setCreativeTab(ModCreativeTabs.tabStorageDrawers);
        this.setTextureName("StorageDrawers:upgrade_sorting");
        this.setMaxDamage(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        String name = this.getUnlocalizedName(itemStack);
        list.add(StatCollector.translateToLocalFormatted((String)(name + ".description"), (Object[])new Object[0]));
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return false;
        }
        if (world.getBlock(x, y, z) == ModBlocks.trim && BlockSortingTrim.upgradeToSorting(world, x, y, z)) {
            --stack.stackSize;
            return true;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileEntityDrawersStandard) {
            if (BlockSortingDrawers.upgradeToSorting(world, x, y, z)) {
                --stack.stackSize;
                return true;
            }
        } else if (tile instanceof TileEntityDrawersComp && BlockSortingCompDrawers.upgradeToSorting(world, x, y, z)) {
            --stack.stackSize;
            return true;
        }
        return false;
    }
}

