/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.InventoryStorage;
import com.jaquadro.minecraft.storagedrawers.inventory.InventoryUpgrade;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotStorage;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerDrawers
extends Container {
    private static final int InventoryX = 8;
    private static final int InventoryY = 117;
    private static final int HotbarY = 175;
    private static final int UpgradeX = 44;
    private static final int UpgradeY = 86;
    private IInventory storageInventory;
    private IInventory upgradeInventory;
    private List<Slot> storageSlots;
    private List<Slot> upgradeSlots;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;

    public ContainerDrawers(InventoryPlayer playerInventory, TileEntityDrawers tileEntity) {
        int i;
        this.storageInventory = new InventoryStorage(tileEntity);
        this.upgradeInventory = new InventoryUpgrade(tileEntity);
        this.storageSlots = new ArrayList<Slot>();
        for (i = 0; i < tileEntity.getDrawerCount(); ++i) {
            this.storageSlots.add(this.addSlotToContainer(new SlotStorage(this.storageInventory, i, this.getStorageSlotX(i), this.getStorageSlotY(i))));
        }
        this.upgradeSlots = new ArrayList<Slot>();
        for (i = 0; i < 5; ++i) {
            this.upgradeSlots.add(this.addSlotToContainer(new SlotUpgrade(this.upgradeInventory, i, 44 + i * 18, 86)));
        }
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.addSlotToContainer(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 117 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.addSlotToContainer(new Slot((IInventory)playerInventory, i, 8 + i * 18, 175)));
        }
    }

    public InventoryStorage getStorageInventory() {
        return (InventoryStorage)this.storageInventory;
    }

    protected int getStorageSlotX(int slot) {
        return 0;
    }

    protected int getStorageSlotY(int slot) {
        return 0;
    }

    public List<Slot> getStorageSlots() {
        return this.storageSlots;
    }

    public List<Slot> getUpgradeSlots() {
        return this.upgradeSlots;
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.storageInventory.isUseableByPlayer(player) || this.upgradeInventory.isUseableByPlayer(player);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        int storageStart = this.storageSlots.get((int)0).slotNumber;
        int storageEnd = this.storageSlots.get((int)(this.storageSlots.size() - 1)).slotNumber + 1;
        int upgradeStart = this.upgradeSlots.get((int)0).slotNumber;
        int upgradeEnd = this.upgradeSlots.get((int)(this.upgradeSlots.size() - 1)).slotNumber + 1;
        int inventoryStart = this.playerSlots.get((int)0).slotNumber;
        int hotbarStart = this.hotbarSlots.get((int)0).slotNumber;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).slotNumber + 1;
        if (slot != null && slot.getHasStack()) {
            ItemStack slotStack = slot.getStack();
            itemStack = slotStack.copy();
            if (slotIndex >= upgradeStart && slotIndex < upgradeEnd) {
                if (!this.mergeItemStack(slotStack, inventoryStart, hotbarEnd, true)) {
                    return null;
                }
                slot.onSlotChange(slotStack, itemStack);
            } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd && slotStack != null ? (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.mergeItemStack(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.mergeItemStack(slotStack, inventoryStart, hotbarStart, false)) : !this.mergeItemStack(slotStack, inventoryStart, hotbarEnd, false)) {
                return null;
            }
            if (slotStack.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
            if (slotStack.stackSize == itemStack.stackSize) {
                return null;
            }
            slot.onPickupFromSlot(player, slotStack);
        }
        return itemStack;
    }
}

