/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.renderer.StorageRenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryStorage
implements IInventory {
    public StorageRenderItem activeRenderItem;
    private TileEntityDrawers tile;
    private InventorySnapshot snapshot;

    public InventoryStorage(TileEntityDrawers tileEntity) {
        this.tile = tileEntity;
        this.snapshot = new InventorySnapshot(this.tile.getSizeInventory());
    }

    public int getSizeInventory() {
        return this.tile.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slot) {
        int drawerSlot = this.tile.getDrawerInventory().getDrawerSlot(slot);
        if (!this.tile.isDrawerEnabled(drawerSlot)) {
            return null;
        }
        IDrawer drawer = this.tile.getDrawer(drawerSlot);
        ItemStack stack = drawer.getStoredItemCopy();
        if (stack == null) {
            return null;
        }
        stack.stackSize = drawer.getStoredItemCount();
        ItemStack snapStack = this.snapshot.takeSnapshot(stack, slot);
        if (this.activeRenderItem != null) {
            this.activeRenderItem.overrideStack = snapStack;
        }
        return snapStack;
    }

    public ItemStack decrStackSize(int slot, int count) {
        return this.snapshot.takeSnapshot(this.tile.decrStackSize(slot, count), slot);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
    }

    public String getInventoryName() {
        return this.tile.getInventoryName();
    }

    public boolean hasCustomInventoryName() {
        return this.tile.hasCustomInventoryName();
    }

    public int getInventoryStackLimit() {
        int limit = this.tile.getInventoryStackLimit();
        return limit > 64 ? 64 : limit;
    }

    public void markDirty() {
        int n = this.getSizeInventory();
        for (int i = 0; i < n; ++i) {
            ItemStack stack;
            int diff = this.snapshot.splitDiff(i);
            if (diff == 0 || (stack = this.tile.getStackInSlot(i)) == null) continue;
            stack.stackSize += diff;
        }
        this.tile.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.tile.isUseableByPlayer(player);
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return this.tile.isItemValidForSlot(slot, stack);
    }

    private static class InventorySnapshot {
        private ItemStack[] snapshotItems;
        private int[] snapshotCounts;

        public InventorySnapshot(int size) {
            this.snapshotItems = new ItemStack[size];
            this.snapshotCounts = new int[this.snapshotItems.length];
        }

        public ItemStack takeSnapshot(ItemStack stack, int slot) {
            if (stack != null) {
                this.snapshotItems[slot] = stack;
                this.snapshotCounts[slot] = stack.stackSize;
            } else {
                this.snapshotItems[slot] = null;
                this.snapshotCounts[slot] = 0;
            }
            return stack;
        }

        public int getDiff(int slot) {
            if (this.snapshotItems[slot] == null) {
                return 0;
            }
            return this.snapshotItems[slot].stackSize - this.snapshotCounts[slot];
        }

        public int splitDiff(int slot) {
            int diff = this.getDiff(slot);
            if (diff != 0) {
                this.snapshotCounts[slot] = this.snapshotItems[slot].stackSize;
            }
            return diff;
        }
    }
}

