/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.storage;

import com.jaquadro.minecraft.storagedrawers.api.event.DrawerPopulatedEvent;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ILockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IQuantifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IShroudable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.storage.BaseDrawerData;
import com.jaquadro.minecraft.storagedrawers.storage.IStorageProvider;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

public class DrawerData
extends BaseDrawerData
implements IVoidable,
IShroudable,
ILockable,
IQuantifiable {
    private static final ItemStack nullStack = new ItemStack((Item)null);
    private IStorageProvider storageProvider;
    private int slot;
    private ItemStack protoStack;
    private int count;

    public DrawerData(IStorageProvider provider, int slot) {
        this.storageProvider = provider;
        this.protoStack = nullStack;
        this.slot = slot;
        this.postInit();
    }

    @Override
    public boolean isVendingUnlimited() {
        return this.storageProvider.isVendingUnlimited(this.slot);
    }

    @Override
    public ItemStack getStoredItemPrototype() {
        if (this.protoStack == nullStack) {
            return null;
        }
        return this.protoStack;
    }

    @Override
    public void setStoredItem(ItemStack itemPrototype, int amount) {
        this.setStoredItem(itemPrototype, amount, true);
    }

    @Override
    public IDrawer setStoredItemRedir(ItemStack itemPrototype, int amount) {
        this.setStoredItem(itemPrototype, amount, true);
        return this;
    }

    private void setStoredItem(ItemStack itemPrototype, int amount, boolean mark) {
        if (itemPrototype == null) {
            this.setStoredItemCount(0, false, true);
            this.protoStack = nullStack;
            this.inventoryStack.reset();
            DrawerPopulatedEvent event = new DrawerPopulatedEvent(this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (mark) {
                this.storageProvider.markDirty(this.slot);
            }
            return;
        }
        this.protoStack = itemPrototype.copy();
        this.protoStack.stackSize = 1;
        this.refreshOreDictMatches();
        this.setStoredItemCount(amount, mark, false);
        this.inventoryStack.reset();
        DrawerPopulatedEvent event = new DrawerPopulatedEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (mark) {
            this.storageProvider.markDirty(this.slot);
        }
    }

    @Override
    public int getStoredItemCount() {
        if (this.protoStack != nullStack && this.isVendingUnlimited()) {
            return Integer.MAX_VALUE;
        }
        return this.count;
    }

    @Override
    public void setStoredItemCount(int amount) {
        this.setStoredItemCount(amount, true, true);
    }

    public void setStoredItemCount(int amount, boolean mark, boolean clearOnEmpty) {
        if (this.isVendingUnlimited()) {
            return;
        }
        this.count = amount;
        if (this.count > this.getMaxCapacity()) {
            this.count = this.getMaxCapacity();
        }
        if (amount == 0) {
            if (clearOnEmpty) {
                if (!this.storageProvider.isLocked(this.slot, LockAttribute.LOCK_POPULATED)) {
                    this.reset();
                }
                if (mark) {
                    this.storageProvider.markDirty(this.slot);
                }
            }
        } else if (mark) {
            this.storageProvider.markAmountDirty(this.slot);
        }
    }

    @Override
    public int getMaxCapacity() {
        return this.getMaxCapacity(this.protoStack);
    }

    @Override
    public int getMaxCapacity(ItemStack itemPrototype) {
        if (itemPrototype == null || itemPrototype.getItem() == null) {
            return 0;
        }
        if (this.storageProvider.isStorageUnlimited(this.slot) || this.storageProvider.isVendingUnlimited(this.slot)) {
            return Integer.MAX_VALUE;
        }
        return itemPrototype.getItem().getItemStackLimit(itemPrototype) * this.storageProvider.getSlotStackCapacity(this.slot);
    }

    @Override
    public int getRemainingCapacity() {
        if (this.protoStack.getItem() == null) {
            return 0;
        }
        if (this.storageProvider.isVendingUnlimited(this.slot)) {
            return Integer.MAX_VALUE;
        }
        return this.getMaxCapacity() - this.getStoredItemCount();
    }

    @Override
    public int getStoredItemStackSize() {
        if (this.protoStack.getItem() == null) {
            return 0;
        }
        return this.protoStack.getItem().getItemStackLimit(this.protoStack);
    }

    @Override
    protected int getItemCapacityForInventoryStack() {
        if (this.storageProvider.isVoid(this.slot)) {
            return Integer.MAX_VALUE;
        }
        return this.getMaxCapacity();
    }

    @Override
    public boolean canItemBeStored(ItemStack itemPrototype) {
        if (this.protoStack == nullStack && !this.isLocked(LockAttribute.LOCK_EMPTY)) {
            return true;
        }
        return this.areItemsEqual(itemPrototype);
    }

    @Override
    public boolean canItemBeExtracted(ItemStack itemPrototype) {
        if (this.protoStack == nullStack) {
            return false;
        }
        return this.areItemsEqual(itemPrototype);
    }

    @Override
    public boolean isEmpty() {
        return this.protoStack == nullStack;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        if (this.protoStack.getItem() != null) {
            tag.setShort("Item", (short)Item.getIdFromItem((Item)this.protoStack.getItem()));
            tag.setShort("Meta", (short)this.protoStack.getItemDamage());
            tag.setInteger("Count", this.count);
            if (this.protoStack.getTagCompound() != null) {
                tag.setTag("Tags", (NBTBase)this.protoStack.getTagCompound());
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.hasKey("Item") && tag.hasKey("Count")) {
            Item item = Item.getItemById((int)tag.getShort("Item"));
            if (item != null) {
                ItemStack stack = new ItemStack(item);
                stack.setItemDamage((int)tag.getShort("Meta"));
                if (tag.hasKey("Tags")) {
                    stack.setTagCompound(tag.getCompoundTag("Tags"));
                }
                this.setStoredItem(stack, tag.getInteger("Count"), false);
            } else {
                this.reset();
            }
        } else {
            this.reset();
        }
    }

    @Override
    protected void reset() {
        this.protoStack = nullStack;
        super.reset();
        DrawerPopulatedEvent event = new DrawerPopulatedEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public boolean isVoid() {
        return this.storageProvider.isVoid(this.slot);
    }

    @Override
    public boolean isShrouded() {
        return this.storageProvider.isShrouded(this.slot);
    }

    @Override
    public boolean setIsShrouded(boolean state) {
        return this.storageProvider.setIsShrouded(this.slot, state);
    }

    @Override
    public boolean isQuantified() {
        return this.storageProvider.isQuantified(this.slot);
    }

    @Override
    public boolean setIsQuantified(boolean state) {
        return this.storageProvider.setIsQuantified(this.slot, state);
    }

    @Override
    public boolean isLocked(LockAttribute attr) {
        return this.storageProvider.isLocked(this.slot, attr);
    }

    @Override
    public boolean canLock(LockAttribute attr) {
        return false;
    }

    @Override
    public void setLocked(LockAttribute attr, boolean isLocked) {
    }
}

