/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.integration.BackhandIntegrationModule;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import xonin.backhand.api.core.BackhandUtils;

public class BlockController
extends BlockContainer
implements INetworked {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFront;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSideEtched;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTrim;

    public BlockController(String blockName) {
        super(Material.rock);
        this.useNeighborBrightness = true;
        this.setCreativeTab(ModCreativeTabs.tabStorageDrawers);
        this.setHardness(5.0f);
        this.setBlockName(blockName);
        this.setStepSound(Block.soundTypeStone);
        this.setLightOpacity(255);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.setTickRandomly(true);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return StorageDrawers.proxy.controllerRenderID;
    }

    public int tickRate(World world) {
        return 100;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        TileEntityController tile = this.getTileEntitySafe(world, x, y, z);
        if (tile.getDirection() > 1) {
            return;
        }
        int quadrant = MathHelper.floor_double((double)((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        switch (quadrant) {
            case 0: {
                tile.setDirection(2);
                break;
            }
            case 1: {
                tile.setDirection(5);
                break;
            }
            case 2: {
                tile.setDirection(3);
                break;
            }
            case 3: {
                tile.setDirection(4);
            }
        }
        if (itemStack.hasDisplayName()) {
            tile.setInventoryName(itemStack.getDisplayName());
        }
        if (world.isRemote) {
            tile.invalidate();
            world.markBlockForUpdate(x, y, z);
        }
    }

    public void onPostBlockPlaced(World world, int x, int y, int z, int meta) {
        if (world.isRemote) {
            return;
        }
        TileEntityController te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.updateCache();
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityController te = this.getTileEntitySafe(world, x, y, z);
        ItemStack item = player.inventory.getCurrentItem();
        if (BackhandIntegrationModule.isEnabled() && BackhandUtils.getOffhandItem((EntityPlayer)player) != null && item == null && BackhandUtils.useOffhandItem((EntityPlayer)player, () -> true)) {
            return false;
        }
        if (item != null && item.getItem() != null) {
            if (item.getItem() == ModItems.shroudKey) {
                if (!world.isRemote) {
                    te.toggleShroud(player.getGameProfile());
                }
                return true;
            }
            if (item.getItem() == ModItems.upgradeLock) {
                if (!world.isRemote) {
                    te.toggleLock(EnumSet.allOf(LockAttribute.class), LockAttribute.LOCK_POPULATED, player.getGameProfile());
                }
                return true;
            }
            if (item.getItem() == ModItems.personalKey) {
                if (!world.isRemote) {
                    String securityKey = ((ItemPersonalKey)item.getItem()).getSecurityProviderKey(item.getItemDamage());
                    ISecurityProvider provider = StorageDrawers.securityRegistry.getProvider(securityKey);
                    te.toggleProtection(player.getGameProfile(), provider);
                }
                return true;
            }
            if (item.getItem() == ModItems.quantifyKey) {
                if (!world.isRemote) {
                    te.toggleQuantify(player.getGameProfile());
                }
                return true;
            }
        }
        if (te.getDirection() != side) {
            return false;
        }
        if (!world.isRemote) {
            te.interactPutItemsIntoInventory(player);
        }
        return true;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntityController tile = this.getTileEntitySafe(world, x, y, z);
        if (tile.getDirection() == axis.ordinal()) {
            return false;
        }
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            return false;
        }
        tile.setDirection(axis.ordinal());
        world.markBlockForUpdate(x, y, z);
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        if (this.getTileEntity(world, x, y, z) == null) {
            return true;
        }
        return side.ordinal() != this.getTileEntity(world, x, y, z).getDirection();
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isRemote) {
            return;
        }
        TileEntityController te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.updateCache();
        world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate(world));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        switch (side) {
            case 0: 
            case 1: {
                return this.iconSide;
            }
            case 4: {
                return this.iconFront;
            }
        }
        return this.iconSideEtched;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityController tile = this.getTileEntity(blockAccess, x, y, z);
        if (tile == null) {
            return this.iconFront;
        }
        if (side == tile.getDirection()) {
            return this.iconFront;
        }
        switch (side) {
            case 0: 
            case 1: {
                return this.iconSide;
            }
        }
        return this.iconSideEtched;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTrim(int meta) {
        return this.iconTrim;
    }

    public TileEntityController createNewTileEntity(World world, int meta) {
        return new TileEntityController();
    }

    public TileEntityController getTileEntity(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tile = blockAccess.getTileEntity(x, y, z);
        return tile instanceof TileEntityController ? (TileEntityController)tile : null;
    }

    public TileEntityController getTileEntitySafe(World world, int x, int y, int z) {
        TileEntityController tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null) {
            tile = this.createNewTileEntity(world, world.getBlockMetadata(x, y, z));
            world.setTileEntity(x, y, z, (TileEntity)tile);
        }
        return tile;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.iconFront = register.registerIcon("StorageDrawers:drawers_controller_front");
        this.iconSide = register.registerIcon("StorageDrawers:drawers_comp_side");
        this.iconSideEtched = register.registerIcon("StorageDrawers:drawers_comp_side_2");
        this.iconTrim = register.registerIcon("StorageDrawers:drawers_comp_trim");
    }
}

