/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.IExtendedBlockClickHandler;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.handlers.GuiHandler;
import com.jaquadro.minecraft.storagedrawers.integration.BackhandIntegrationModule;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemTrim;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeCreative;
import com.jaquadro.minecraft.storagedrawers.network.BlockClickMessage;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.avaritia.items.ItemMatterCluster;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockWood;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.IResource;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.Level;
import xonin.backhand.api.core.BackhandUtils;

public class BlockDrawers
extends BlockContainer
implements IExtendedBlockClickHandler,
INetworked {
    private static final ResourceLocation blockConfig = new ResourceLocation("StorageDrawers:textures/blocks/block_config.mcmeta");
    public final boolean halfDepth;
    public final int drawerCount;
    private float trimWidth = 0.0625f;
    private float trimDepth = 0.0625f;
    private float indStart = 0.0f;
    private float indEnd = 0.0f;
    private int indSteps = 0;
    private String blockConfigName;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconSide;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconSideV;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconSideH;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconFront1;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconFront2;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconFront4;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconTrim;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlay;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayV;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayH;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayTrim;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconIndicator1;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconIndicator2;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconIndicator4;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconLock;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconClaim;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconClaimLock;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconVoid;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTaped;
    private long ignoreEventTime;

    public BlockDrawers(String blockName, int drawerCount, boolean halfDepth) {
        this(Material.wood, blockName, drawerCount, halfDepth);
    }

    protected BlockDrawers(Material material, String blockName, int drawerCount, boolean halfDepth) {
        super(material);
        this.drawerCount = drawerCount;
        this.halfDepth = halfDepth;
        this.useNeighborBrightness = true;
        this.setCreativeTab(ModCreativeTabs.tabStorageDrawers);
        this.setHardness(5.0f);
        this.setStepSound(Block.soundTypeWood);
        this.setBlockName(blockName);
        this.setConfigName(blockName);
        this.setLightOpacity(255);
    }

    public boolean retrimBlock(World world, int x, int y, int z, ItemStack prototype) {
        if (this.retrimType() == null) {
            return false;
        }
        Block protoBlock = Block.getBlockFromItem((Item)prototype.getItem());
        int protoMeta = prototype.getItemDamage();
        BlockConfiguration config = BlockConfiguration.by(this.retrimType(), this.drawerCount, this.halfDepth);
        Block plankBlock = StorageDrawers.blockRegistry.getPlankBlock(BlockConfiguration.Trim, protoBlock, protoMeta);
        int plankMeta = StorageDrawers.blockRegistry.getPlankMeta(BlockConfiguration.Trim, protoBlock, protoMeta);
        Block newBlock = StorageDrawers.blockRegistry.getBlock(config, plankBlock, plankMeta);
        int newMeta = StorageDrawers.blockRegistry.getMeta(config, plankBlock, plankMeta);
        if (newBlock == null) {
            return false;
        }
        TileEntityDrawers tile = BlockDrawers.getTileEntity((IBlockAccess)world, x, y, z);
        if (newBlock == this && newMeta == world.getBlockMetadata(x, y, z) && !tile.shouldHideUpgrades()) {
            tile.setShouldHideUpgrades(true);
            return true;
        }
        if (newBlock == this) {
            world.setBlockMetadataWithNotify(x, y, z, newMeta, 3);
        } else {
            TileEntityDrawers newDrawer = this.createNewTileEntity(world, newMeta);
            NBTTagCompound tag = new NBTTagCompound();
            tile.writeToNBT(tag);
            newDrawer.readFromNBT(tag);
            world.removeTileEntity(x, y, z);
            world.setBlockToAir(x, y, z);
            world.setBlock(x, y, z, newBlock, newMeta, 3);
            world.setTileEntity(x, y, z, (TileEntity)newDrawer);
        }
        return true;
    }

    public BlockType retrimType() {
        return BlockType.Drawers;
    }

    public float getTrimWidth() {
        return this.trimWidth;
    }

    public float getTrimDepth() {
        return this.trimDepth;
    }

    public float getIndStart() {
        return this.indStart;
    }

    public float getIndEnd() {
        return this.indEnd;
    }

    public int getIndSteps() {
        return this.indSteps;
    }

    public BlockDrawers setConfigName(String name) {
        this.blockConfigName = name;
        return this;
    }

    public String getConfigName() {
        return this.blockConfigName;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return StorageDrawers.proxy.drawersRenderID;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntityDrawers tile = BlockDrawers.getTileEntity(blockAccess, x, y, z);
        if (tile == null) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        float depth = this.halfDepth ? 0.5f : 1.0f;
        switch (tile.getDirection()) {
            case 2: {
                this.setBlockBounds(0.0f, 0.0f, 1.0f - depth, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, depth);
                break;
            }
            case 4: {
                this.setBlockBounds(1.0f - depth, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, depth, 1.0f, 1.0f);
            }
        }
    }

    public void setBlockBoundsForItemRender() {
        if (this.halfDepth) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        super.addCollisionBoxesToList(world, x, y, z, aabb, list, entity);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        TileEntityDrawers tile = this.getTileEntitySafe(world, x, y, z);
        if (tile.getDirection() > 1) {
            return;
        }
        int quadrant = MathHelper.floor_double((double)((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        switch (quadrant) {
            case 0: {
                tile.setDirection(2);
                break;
            }
            case 1: {
                tile.setDirection(5);
                break;
            }
            case 2: {
                tile.setDirection(3);
                break;
            }
            case 3: {
                tile.setDirection(4);
            }
        }
        if (itemStack.hasDisplayName()) {
            tile.setInventoryName(itemStack.getDisplayName());
        }
        if (BackhandIntegrationModule.isEnabled() && entity instanceof EntityPlayer) {
            ItemStack offhandItem = BackhandUtils.getOffhandItem((EntityPlayer)((EntityPlayer)entity));
            this.useKey(tile, (EntityPlayer)entity, offhandItem, 0, 0.0f, 0.0f, 0.0f);
        }
        if (world.isRemote) {
            tile.invalidate();
            world.markBlockForUpdate(x, y, z);
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote && Minecraft.getSystemTime() == this.ignoreEventTime) {
            this.ignoreEventTime = 0L;
            return false;
        }
        TileEntityDrawers tileDrawers = this.getTileEntitySafe(world, x, y, z);
        ItemStack item = player.inventory.getCurrentItem();
        if (BackhandIntegrationModule.isEnabled() && BackhandUtils.getOffhandItem((EntityPlayer)player) != null && item == null && BackhandUtils.useOffhandItem((EntityPlayer)player, () -> true)) {
            return false;
        }
        if (!SecurityManager.hasAccess(player.getGameProfile(), tileDrawers)) {
            return false;
        }
        if (StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)"BlockDrawers.onBlockActivated", (Object[])new Object[0]);
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)(item == null ? "  null item" : "  " + item), (Object[])new Object[0]);
        }
        if (item != null && item.getItem() != null) {
            if (item.getItem() instanceof ItemTrim && player.isSneaking()) {
                if (!this.retrimBlock(world, x, y, z, item)) {
                    return false;
                }
                if (!player.capabilities.isCreativeMode && --item.stackSize <= 0) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                }
                return true;
            }
            if (item.getItem() == ModItems.upgrade || item.getItem() == ModItems.upgradeStatus || item.getItem() == ModItems.upgradeVoid || item.getItem() == ModItems.upgradeCreative || item.getItem() == ModItems.upgradeRedstone || item.getItem() == ModItems.upgradeDowngrade) {
                if (!tileDrawers.addUpgrade(item)) {
                    player.addChatMessage((IChatComponent)new ChatComponentTranslation("storagedrawers.msg.maxUpgrades", new Object[0]));
                    return false;
                }
                world.markBlockForUpdate(x, y, z);
                if (!player.capabilities.isCreativeMode && --item.stackSize <= 0) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                }
                return true;
            }
            if (this.useKey(tileDrawers, player, item, side, hitX, hitY, hitZ)) {
                return true;
            }
        } else if (item == null && player.isSneaking()) {
            if (tileDrawers.isSealed()) {
                tileDrawers.setIsSealed(false);
                return true;
            }
            if (StorageDrawers.config.cache.enableDrawerUI) {
                player.openGui((Object)StorageDrawers.instance, GuiHandler.drawersGuiID, world, x, y, z);
                return true;
            }
        }
        if (tileDrawers.getDirection() != side) {
            return false;
        }
        if (tileDrawers.isSealed()) {
            return false;
        }
        int slot = this.getDrawerSlot(side, hitX, hitY, hitZ);
        IDrawer drawer = tileDrawers.getDrawer(slot);
        if (drawer != null) {
            ItemStack currentStack = drawer.getStoredItemPrototype();
            int countAdded = tileDrawers.interactPutItemsIntoSlot(slot, player);
            if (countAdded > 0 && currentStack != null) {
                world.markBlockForUpdate(x, y, z);
            }
        }
        return true;
    }

    private boolean useKey(TileEntityDrawers tileDrawers, EntityPlayer player, ItemStack item, int side, float hitX, float hitY, float hitZ) {
        if (item != null && item.getItem() != null) {
            if (item.getItem() == ModItems.upgradeLock) {
                int slot;
                IDrawer drawer;
                boolean locked = tileDrawers.isLocked(LockAttribute.LOCK_POPULATED);
                if (locked && (drawer = tileDrawers.getDrawer(slot = this.getDrawerSlot(side, hitX, hitY, hitZ))) != null) {
                    ItemStack stack = drawer.getStoredItemPrototype();
                    int count = drawer.getStoredItemCount();
                    if (stack != null && count == 0) {
                        drawer.setStoredItemRedir(null, 0);
                        return true;
                    }
                }
                tileDrawers.setLocked(LockAttribute.LOCK_POPULATED, !locked);
                tileDrawers.setLocked(LockAttribute.LOCK_EMPTY, !locked);
                return true;
            }
            if (item.getItem() == ModItems.shroudKey) {
                tileDrawers.setIsShrouded(!tileDrawers.isShrouded());
                return true;
            }
            if (item.getItem() == ModItems.quantifyKey) {
                tileDrawers.setIsQuantified(!tileDrawers.isQuantified());
                return true;
            }
            if (item.getItem() instanceof ItemPersonalKey) {
                String securityKey = ((ItemPersonalKey)item.getItem()).getSecurityProviderKey(item.getItemDamage());
                ISecurityProvider provider = StorageDrawers.securityRegistry.getProvider(securityKey);
                if (tileDrawers.getOwner() == null) {
                    tileDrawers.setOwner(player.getPersistentID());
                    tileDrawers.setSecurityProvider(provider);
                } else if (SecurityManager.hasOwnership(player.getGameProfile(), tileDrawers)) {
                    tileDrawers.setOwner(null);
                    tileDrawers.setSecurityProvider(null);
                } else {
                    return false;
                }
                return true;
            }
            if (item.getItem() == ModItems.tape) {
                return false;
            }
        }
        return false;
    }

    protected int getDrawerSlot(int side, float hitX, float hitY, float hitZ) {
        if (this.drawerCount == 1) {
            return 0;
        }
        if (this.drawerCount == 2) {
            return this.hitTop(hitY) ? 0 : 1;
        }
        if (this.hitLeft(side, hitX, hitZ)) {
            return this.hitTop(hitY) ? 0 : 1;
        }
        return this.hitTop(hitY) ? 2 : 3;
    }

    protected boolean hitTop(float hitY) {
        return (double)hitY > 0.5;
    }

    protected boolean hitLeft(int side, float hitX, float hitZ) {
        switch (side) {
            case 2: {
                return (double)hitX > 0.5;
            }
            case 3: {
                return (double)hitX < 0.5;
            }
            case 4: {
                return (double)hitZ < 0.5;
            }
            case 5: {
                return (double)hitZ > 0.5;
            }
        }
        return true;
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (world.isRemote) {
            MovingObjectPosition posn = Minecraft.getMinecraft().objectMouseOver;
            float hitX = (float)(posn.hitVec.xCoord - (double)posn.blockX);
            float hitY = (float)(posn.hitVec.yCoord - (double)posn.blockY);
            float hitZ = (float)(posn.hitVec.zCoord - (double)posn.blockZ);
            StorageDrawers.network.sendToServer((IMessage)new BlockClickMessage(x, y, z, posn.sideHit, hitX, hitY, hitZ, StorageDrawers.config.cache.invertShift));
            if (StorageDrawers.config.cache.debugTrace) {
                FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("BlockDrawers.onBlockClicked with " + posn), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ, boolean invertShift) {
        PlayerInteractEvent event;
        if (StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)"IExtendedBlockClickHandler.onBlockClicked", (Object[])new Object[0]);
        }
        if (!player.capabilities.isCreativeMode && (event = ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK, (int)x, (int)y, (int)z, (int)side, (World)world)).isCanceled()) {
            return;
        }
        TileEntityDrawers tileDrawers = this.getTileEntitySafe(world, x, y, z);
        if (tileDrawers.getDirection() != side) {
            return;
        }
        if (tileDrawers.isSealed()) {
            return;
        }
        if (!SecurityManager.hasAccess(player.getGameProfile(), tileDrawers)) {
            return;
        }
        int slot = this.getDrawerSlot(side, hitX, hitY, hitZ);
        IDrawer drawer = tileDrawers.getDrawer(slot);
        if (drawer == null) {
            return;
        }
        ItemStack item = player.isSneaking() != invertShift ? tileDrawers.takeItemsFromSlot(slot, drawer.getStoredItemStackSize()) : tileDrawers.takeItemsFromSlot(slot, 1);
        if (StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)(item == null ? "  null item" : "  " + item), (Object[])new Object[0]);
        }
        if (item != null && item.stackSize > 0) {
            if (!player.inventory.addItemStackToInventory(item)) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                this.dropItemStack(world, x + dir.offsetX, y, z + dir.offsetZ, item);
                world.markBlockForUpdate(x, y, z);
            } else {
                world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.pop", 0.2f, ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntityDrawers tile = this.getTileEntitySafe(world, x, y, z);
        if (tile.isSealed()) {
            this.dropBlockAsItem(world, x, y, z, world.getBlockMetadata(x, y, z), 0);
            world.setBlockToAir(x, y, z);
            return true;
        }
        if (tile.getDirection() == axis.ordinal()) {
            return false;
        }
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            return false;
        }
        tile.setDirection(axis.ordinal());
        world.markBlockForUpdate(x, y, z);
        if (world.isRemote) {
            this.ignoreEventTime = Minecraft.getSystemTime();
        }
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        Block blockUnder;
        if (this.halfDepth) {
            return false;
        }
        if (side == ForgeDirection.DOWN && ((blockUnder = world.getBlock(x, y - 1, z)) instanceof BlockChest || blockUnder instanceof BlockEnderChest)) {
            return false;
        }
        if (BlockDrawers.getTileEntity(world, x, y, z) == null) {
            return true;
        }
        return side.ordinal() != BlockDrawers.getTileEntity(world, x, y, z).getDirection();
    }

    private void dropItemStack(World world, int x, int y, int z, ItemStack stack) {
        EntityItem entity = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), stack);
        entity.addVelocity(-entity.motionX, -entity.motionY, -entity.motionZ);
        world.spawnEntityInWorld((Entity)entity);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (world.isRemote && player.capabilities.isCreativeMode) {
            TileEntityDrawers tile = BlockDrawers.getTileEntity((IBlockAccess)world, x, y, z);
            MovingObjectPosition posn = Minecraft.getMinecraft().objectMouseOver;
            if (tile.getDirection() == posn.sideHit) {
                this.onBlockClicked(world, x, y, z, player);
                return false;
            }
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        TileEntityDrawers tile = BlockDrawers.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile != null && !tile.isSealed()) {
            for (int i = 0; i < tile.getUpgradeSlotCount(); ++i) {
                ItemStack stack = tile.getUpgrade(i);
                if (stack == null || stack.getItem() instanceof ItemUpgradeCreative) continue;
                this.dropBlockAsItem(world, x, y, z, stack);
            }
            if (!tile.isVending()) {
                switch (StorageDrawers.config.cache.breakDrawerDropMode) {
                    case "merge": {
                        BlockDrawers.dropMergedStacks(tile, world, x, y, z);
                        break;
                    }
                    case "destroy": {
                        BlockDrawers.dropStacksAndDestroyExcess(tile, world, x, y, z);
                        break;
                    }
                    case "mixed": {
                        BlockDrawers.dropStacksMixedBehavior(tile, world, x, y, z);
                        break;
                    }
                    case "cluster": {
                        if (Loader.isModLoaded((String)"Avaritia")) {
                            BlockDrawers.dropAvaritiaClusters(tile, world, x, y, z);
                        }
                    }
                    default: {
                        BlockDrawers.dropAllStacksOfDrawer(tile, world, x, y, z);
                    }
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    private static void forEachSplitStackOfSubDrawer(TileEntityDrawers drawer, int drawerIndex, Consumer<ItemStack> action) {
        ItemStack stack;
        if (!drawer.isDrawerEnabled(drawerIndex)) {
            return;
        }
        IDrawer subDrawer = drawer.getDrawer(drawerIndex);
        while (subDrawer.getStoredItemCount() > 0 && (stack = drawer.takeItemsFromSlot(drawerIndex, subDrawer.getStoredItemStackSize())) != null && stack.stackSize != 0) {
            action.accept(stack);
        }
    }

    private static void spawnStackInWorld(World world, int x, int y, int z, ItemStack stack) {
        Random rand = world.rand;
        while (stack.stackSize > 0) {
            int stackSize = Math.min(stack.stackSize, stack.getMaxStackSize());
            stack.stackSize -= stackSize;
            ItemStack newStack = new ItemStack(stack.getItem(), stackSize, stack.getItemDamage());
            if (stack.hasTagCompound()) {
                newStack.setTagCompound((NBTTagCompound)stack.getTagCompound().copy());
            }
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rand.nextFloat() * 0.8f + 0.1f), (double)((float)y + rand.nextFloat() * 0.8f + 0.1f), (double)((float)z + rand.nextFloat() * 0.8f + 0.1f), newStack);
            entityItem.motionX = rand.nextGaussian() * (double)0.05f;
            entityItem.motionY = rand.nextGaussian() * (double)0.05f + (double)0.2f;
            entityItem.motionZ = rand.nextGaussian() * (double)0.05f;
            world.spawnEntityInWorld((Entity)entityItem);
        }
    }

    private static void dropMergedStacks(TileEntityDrawers tile, World world, int x, int y, int z) {
        for (int i = 0; i < tile.getDrawerCount(); ++i) {
            if (!tile.isDrawerEnabled(i)) continue;
            IDrawer drawer = tile.getDrawer(i);
            ItemStack rawStoredItem = drawer.getStoredItemPrototype();
            if (rawStoredItem != null && rawStoredItem.isStackable()) {
                BlockDrawers.dropBigStackInWorld(world, x, y, z, drawer.getStoredItemCopy());
                drawer.setStoredItemCount(0);
                continue;
            }
            BlockDrawers.forEachSplitStackOfSubDrawer(tile, i, stack -> BlockDrawers.spawnStackInWorld(world, x, y, z, stack));
        }
    }

    private static void dropBigStackInWorld(World world, int x, int y, int z, ItemStack stack) {
        if (stack == null || stack.stackSize <= 0) {
            return;
        }
        Random rand = world.rand;
        float ex = rand.nextFloat() * 0.8f + 0.1f;
        float ey = rand.nextFloat() * 0.8f + 0.1f;
        float ez = rand.nextFloat() * 0.8f + 0.1f;
        EntityItem entity = new EntityItem(world, (double)((float)x + ex), (double)((float)y + ey), (double)((float)z + ez), stack);
        if (stack.hasTagCompound()) {
            entity.getEntityItem().setTagCompound((NBTTagCompound)stack.getTagCompound().copy());
        }
        world.spawnEntityInWorld((Entity)entity);
    }

    private static void dropStacksAndDestroyExcess(TileEntityDrawers tile, World world, int x, int y, int z) {
        int maxDropNum = 4096 / tile.getDrawerCount();
        for (int i = 0; i < tile.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!tile.isDrawerEnabled(i) || (drawer = tile.getDrawer(i)).getStoredItemCount() <= maxDropNum) continue;
            drawer.setStoredItemCount(maxDropNum);
        }
        BlockDrawers.dropAllStacksOfDrawer(tile, world, x, y, z);
    }

    private static void dropStacksMixedBehavior(TileEntityDrawers tile, World world, int x, int y, int z) {
        int stacksToSpawn = BlockDrawers.countAmountOfStacksToSpawn(tile);
        if (stacksToSpawn <= 64) {
            BlockDrawers.dropAllStacksOfDrawer(tile, world, x, y, z);
        } else if (Loader.isModLoaded((String)"Avaritia")) {
            BlockDrawers.dropAvaritiaClusters(tile, world, x, y, z);
        } else {
            BlockDrawers.dropMergedStacks(tile, world, x, y, z);
        }
    }

    private static int countAmountOfStacksToSpawn(TileEntityDrawers tile) {
        int stackCount = 0;
        for (int i = 0; i < tile.getDrawerCount(); ++i) {
            IDrawer drawer;
            ItemStack storedItem;
            if (!tile.isDrawerEnabled(i) || (storedItem = (drawer = tile.getDrawer(i)).getStoredItemPrototype()) == null) continue;
            int maxStackSize = storedItem.getMaxStackSize();
            int storedItemCount = drawer.getStoredItemCount();
            stackCount += storedItemCount / maxStackSize;
            if (storedItemCount % maxStackSize == 0) continue;
            ++stackCount;
        }
        return stackCount;
    }

    @Optional.Method(modid="Avaritia")
    private static void dropAvaritiaClusters(TileEntityDrawers tile, World world, int x, int y, int z) {
        for (int i = 0; i < tile.getDrawerCount(); ++i) {
            ArrayList stacks = new ArrayList();
            BlockDrawers.forEachSplitStackOfSubDrawer(tile, i, stacks::add);
            List clusters = ItemMatterCluster.makeClusters(stacks);
            for (ItemStack stack : clusters) {
                BlockDrawers.spawnStackInWorld(world, x, y, z, stack);
            }
        }
    }

    private static void dropAllStacksOfDrawer(TileEntityDrawers tile, World world, int x, int y, int z) {
        for (int i = 0; i < tile.getDrawerCount(); ++i) {
            BlockDrawers.forEachSplitStackOfSubDrawer(tile, i, stack -> BlockDrawers.spawnStackInWorld(world, x, y, z, stack));
        }
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, false);
    }

    public void harvestBlock(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.harvestBlock(world, player, x, y, z, meta);
        world.setBlockToAir(x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ItemStack dropStack = this.getMainDrop(world, x, y, z, metadata);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(dropStack);
        TileEntityDrawers tile = BlockDrawers.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null || !tile.isSealed()) {
            return drops;
        }
        NBTTagCompound tiledata = new NBTTagCompound();
        tile.writeToNBT(tiledata);
        NBTTagCompound data = dropStack.getTagCompound();
        if (data == null) {
            data = new NBTTagCompound();
        }
        data.setTag("tile", (NBTBase)tiledata);
        dropStack.setTagCompound(data);
        return drops;
    }

    protected ItemStack getMainDrop(World world, int x, int y, int z, int metadata) {
        return new ItemStack(Item.getItemFromBlock((Block)this), 1, metadata);
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TileEntityDrawers tile = BlockDrawers.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile != null) {
            for (int slot = 0; slot < 5; ++slot) {
                ItemStack stack = tile.getUpgrade(slot);
                if (stack == null || !(stack.getItem() instanceof ItemUpgrade) || stack.getItemDamage() != 4) continue;
                return 1000.0f;
            }
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public TileEntityDrawers createNewTileEntity(World world, int meta) {
        return new TileEntityDrawersStandard();
    }

    public static TileEntityDrawers getTileEntity(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tile = blockAccess.getTileEntity(x, y, z);
        return tile instanceof TileEntityDrawers ? (TileEntityDrawers)tile : null;
    }

    public TileEntityDrawers getTileEntitySafe(World world, int x, int y, int z) {
        TileEntityDrawers tile = BlockDrawers.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null) {
            tile = this.createNewTileEntity(world, world.getBlockMetadata(x, y, z));
            world.setTileEntity(x, y, z, (TileEntity)tile);
        }
        return tile;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TileEntity tile = worldObj.getTileEntity(target.blockX, target.blockY, target.blockZ);
        if (tile instanceof TileEntityDrawers && ((TileEntityDrawers)tile).getDirection() == target.sideHit) {
            return true;
        }
        return super.addHitEffects(worldObj, target, effectRenderer);
    }

    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        if (StorageDrawers.config.cache.creativeTabVanillaWoods) {
            for (int i = 1; i < BlockWood.field_150096_a.length; ++i) {
                list.add(new ItemStack(item, 1, i));
            }
        }
    }

    public boolean canProvidePower() {
        return true;
    }

    public int isProvidingWeakPower(IBlockAccess blockAccess, int x, int y, int z, int dir) {
        if (!this.canProvidePower()) {
            return 0;
        }
        TileEntityDrawers tile = BlockDrawers.getTileEntity(blockAccess, x, y, z);
        if (tile == null || !tile.isRedstone()) {
            return 0;
        }
        return tile.getRedstoneLevel();
    }

    public int isProvidingStrongPower(IBlockAccess blockAccess, int x, int y, int z, int dir) {
        return dir == 1 ? this.isProvidingWeakPower(blockAccess, x, y, z, dir) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTrim(int meta) {
        meta = meta < 0 || meta >= this.iconTrim.length ? 0 : meta;
        return this.iconTrim[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        meta = meta < 0 || meta >= this.iconSide.length ? 0 : meta;
        switch (side) {
            case 0: 
            case 1: {
                return this.halfDepth ? this.iconSideH[meta] : this.iconSide[meta];
            }
            case 2: 
            case 3: {
                return this.halfDepth ? this.iconSideV[meta] : this.iconSide[meta];
            }
            case 4: {
                switch (this.drawerCount) {
                    case 1: {
                        return this.iconFront1[meta];
                    }
                    case 2: {
                        return this.iconFront2[meta];
                    }
                    case 4: {
                        return this.iconFront4[meta];
                    }
                }
                return null;
            }
            case 5: {
                return this.iconSide[meta];
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return this.getIcon(blockAccess, x, y, z, side, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int level) {
        if (level == 0) {
            return null;
        }
        return this.getIcon(blockAccess, x, y, z, side, level);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayIconTrim(int level) {
        if (level == 0) {
            return null;
        }
        level = level < 0 || level >= this.iconOverlayTrim.length ? 0 : level;
        return this.iconOverlayTrim[level];
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int level) {
        int meta = blockAccess.getBlockMetadata(x, y, z);
        meta = meta < 0 || meta >= this.iconSide.length ? 0 : meta;
        level = level < 0 || level >= this.iconOverlay.length ? 0 : level;
        TileEntityDrawers tile = BlockDrawers.getTileEntity(blockAccess, x, y, z);
        if (tile == null || side == tile.getDirection()) {
            if (this.drawerCount == 1) {
                return this.iconFront1[meta];
            }
            if (this.drawerCount == 2) {
                return this.iconFront2[meta];
            }
            return this.iconFront4[meta];
        }
        switch (side) {
            case 0: 
            case 1: {
                if (!this.halfDepth) break;
                switch (tile.getDirection()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return level > 0 ? this.iconOverlayH[level] : this.iconSideH[meta];
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                if (!this.halfDepth) break;
                switch (tile.getDirection()) {
                    case 2: 
                    case 3: {
                        return level > 0 ? this.iconOverlay[level] : this.iconSide[meta];
                    }
                    case 4: 
                    case 5: {
                        return level > 0 ? this.iconOverlayV[level] : this.iconSideV[meta];
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                if (!this.halfDepth) break;
                switch (tile.getDirection()) {
                    case 2: 
                    case 3: {
                        return level > 0 ? this.iconOverlayV[level] : this.iconSideV[meta];
                    }
                    case 4: 
                    case 5: {
                        return level > 0 ? this.iconOverlay[level] : this.iconSide[meta];
                    }
                }
            }
        }
        return level > 0 ? this.iconOverlay[level] : this.iconSide[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIndicatorIcon(int drawerCount, boolean on) {
        int onIndex = on ? 1 : 0;
        switch (drawerCount) {
            case 1: {
                return this.iconIndicator1[onIndex];
            }
            case 2: {
                return this.iconIndicator2[onIndex];
            }
            case 4: {
                return this.iconIndicator4[onIndex];
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getLockIcon(boolean locked, boolean claimed) {
        if (locked && claimed) {
            return this.iconClaimLock;
        }
        if (locked) {
            return this.iconLock;
        }
        if (claimed) {
            return this.iconClaim;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getVoidIcon() {
        return this.iconVoid;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getTapeIcon() {
        return this.iconTaped;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        String[] subtex = BlockWood.field_150096_a;
        this.iconSide = new IIcon[subtex.length];
        this.iconSideH = new IIcon[subtex.length];
        this.iconSideV = new IIcon[subtex.length];
        this.iconFront1 = new IIcon[subtex.length];
        this.iconFront2 = new IIcon[subtex.length];
        this.iconFront4 = new IIcon[subtex.length];
        this.iconTrim = new IIcon[subtex.length];
        for (int i = 0; i < subtex.length; ++i) {
            this.iconFront1[i] = register.registerIcon("StorageDrawers:drawers_" + subtex[i] + "_front_1");
            this.iconFront2[i] = register.registerIcon("StorageDrawers:drawers_" + subtex[i] + "_front_2");
            this.iconFront4[i] = register.registerIcon("StorageDrawers:drawers_" + subtex[i] + "_front_4");
            this.iconSide[i] = register.registerIcon("StorageDrawers:drawers_" + subtex[i] + "_side");
            this.iconSideV[i] = register.registerIcon("StorageDrawers:drawers_" + subtex[i] + "_side_v");
            this.iconSideH[i] = register.registerIcon("StorageDrawers:drawers_" + subtex[i] + "_side_h");
            this.iconTrim[i] = register.registerIcon("StorageDrawers:drawers_" + subtex[i] + "_trim");
        }
        this.iconTaped = register.registerIcon("StorageDrawers:tape");
        String[] overlays = new String[]{null, null, "iron", "gold", "obsidian", "diamond", "emerald", "ruby", "tanzanite"};
        this.iconOverlay = new IIcon[overlays.length];
        this.iconOverlayH = new IIcon[overlays.length];
        this.iconOverlayV = new IIcon[overlays.length];
        this.iconOverlayTrim = new IIcon[overlays.length];
        for (int i = 2; i < overlays.length; ++i) {
            this.iconOverlay[i] = register.registerIcon("StorageDrawers:overlay_" + overlays[i]);
            this.iconOverlayV[i] = register.registerIcon("StorageDrawers:overlay_" + overlays[i] + "_v");
            this.iconOverlayH[i] = register.registerIcon("StorageDrawers:overlay_" + overlays[i] + "_h");
            this.iconOverlayTrim[i] = register.registerIcon("StorageDrawers:overlay_" + overlays[i] + "_trim");
        }
        this.iconIndicator1 = new IIcon[2];
        this.iconIndicator2 = new IIcon[2];
        this.iconIndicator4 = new IIcon[2];
        this.iconIndicator1[0] = register.registerIcon("StorageDrawers:indicator/indicator_1_off");
        this.iconIndicator1[1] = register.registerIcon("StorageDrawers:indicator/indicator_1_on");
        this.iconIndicator2[0] = register.registerIcon("StorageDrawers:indicator/indicator_2_off");
        this.iconIndicator2[1] = register.registerIcon("StorageDrawers:indicator/indicator_2_on");
        this.iconIndicator4[0] = register.registerIcon("StorageDrawers:indicator/indicator_4_off");
        this.iconIndicator4[1] = register.registerIcon("StorageDrawers:indicator/indicator_4_on");
        this.iconLock = register.registerIcon("StorageDrawers:indicator/lock_icon");
        this.iconClaim = register.registerIcon("StorageDrawers:indicator/claim_icon");
        this.iconClaimLock = register.registerIcon("StorageDrawers:indicator/claim_lock_icon");
        this.iconVoid = register.registerIcon("StorageDrawers:indicator/void_icon");
        this.loadBlockConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    protected void loadBlockConfig() {
        try {
            BufferedReader reader;
            block8: {
                IResource configResource = Minecraft.getMinecraft().getResourceManager().getResource(blockConfig);
                reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(configResource.getInputStream()));
                    JsonObject root = new JsonParser().parse((Reader)reader).getAsJsonObject();
                    JsonObject entry = root.getAsJsonObject(this.getConfigName());
                    if (entry == null) break block8;
                    if (entry.has("trimWidth")) {
                        this.trimWidth = entry.get("trimWidth").getAsFloat();
                    }
                    if (entry.has("trimDepth")) {
                        this.trimDepth = entry.get("trimDepth").getAsFloat();
                    }
                    if (entry.has("indStart")) {
                        this.indStart = entry.get("indStart").getAsFloat();
                    }
                    if (entry.has("indEnd")) {
                        this.indEnd = entry.get("indEnd").getAsFloat();
                    }
                    if (!entry.has("indSteps")) break block8;
                    this.indSteps = entry.get("indSteps").getAsInt();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

