/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.pack;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackBlock;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackDataResolver;
import com.jaquadro.minecraft.storagedrawers.api.pack.TextureType;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class BlockTrimPack
extends BlockTrim
implements IPackBlock {
    private IPackDataResolver resolver;

    public BlockTrimPack(IPackDataResolver resolver) {
        super(resolver.getBlockName(BlockConfiguration.Trim));
        this.resolver = resolver;
        CreativeTabs tabs = resolver.getCreativeTabs(BlockType.Trim);
        if (StorageDrawers.config.cache.addonSeparateVanilla && tabs != null) {
            this.setCreativeTab(tabs);
        } else {
            this.setCreativeTab(ModCreativeTabs.tabStorageDrawers);
        }
    }

    public String[] getUnlocalizedNames() {
        String[] names = new String[16];
        for (int i = 0; i < 16; ++i) {
            if (!this.resolver.isValidMetaValue(i)) continue;
            names[i] = this.resolver.getUnlocalizedName(i);
        }
        return names;
    }

    @Override
    public IPackDataResolver getDataResolver() {
        return this.resolver;
    }

    @Override
    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List list) {
        if (!StorageDrawers.config.cache.addonShowVanilla) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            if (!this.resolver.isValidMetaValue(i)) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.iconTrim[meta %= 16];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.iconTrim = new IIcon[16];
        for (int i = 0; i < 16; ++i) {
            if (!this.resolver.isValidMetaValue(i)) continue;
            this.iconTrim[i] = register.registerIcon(this.resolver.getTexturePath(TextureType.TrimBlock, i));
        }
    }
}

