/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrimCustom;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityFramingTable
extends TileEntity
implements IInventory {
    private ItemStack[] tableItemStacks = new ItemStack[5];
    private String customName;
    private static final AxisAlignedBB ZERO_EXTENT_AABB = AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public int getSizeInventory() {
        return this.tableItemStacks.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.tableItemStacks[slot];
    }

    public ItemStack decrStackSize(int slot, int count) {
        if (this.tableItemStacks[slot] != null) {
            if (this.tableItemStacks[slot].stackSize <= count) {
                ItemStack stack = this.tableItemStacks[slot];
                this.tableItemStacks[slot] = null;
                this.markDirty();
                return stack;
            }
            ItemStack stack = this.tableItemStacks[slot].splitStack(count);
            if (this.tableItemStacks[slot].stackSize == 0) {
                this.tableItemStacks[slot] = null;
            }
            this.markDirty();
            return stack;
        }
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.tableItemStacks[slot] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "storageDrawers.container.framingTable";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            return TileEntityFramingTable.isItemValidDrawer(stack);
        }
        if (slot == 4) {
            return false;
        }
        if (slot >= 1 && slot < 4) {
            return TileEntityFramingTable.isItemValidMaterial(stack);
        }
        return false;
    }

    public static boolean isItemValidDrawer(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Block block = Block.getBlockFromItem((Item)stack.getItem());
        return block instanceof BlockDrawersCustom || block instanceof BlockTrimCustom;
    }

    public static boolean isItemValidMaterial(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Block block = Block.getBlockFromItem((Item)stack.getItem());
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        NBTTagList itemList = tag.getTagList("Items", 10);
        this.tableItemStacks = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < itemList.tagCount(); ++i) {
            NBTTagCompound item = itemList.getCompoundTagAt(i);
            byte slot = item.getByte("Slot");
            if (slot < 0 || slot >= this.tableItemStacks.length) continue;
            this.tableItemStacks[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)item);
        }
        if (tag.hasKey("CustomName", 8)) {
            this.customName = tag.getString("CustomName");
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.tableItemStacks.length; ++i) {
            if (this.tableItemStacks[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.setByte("Slot", (byte)i);
            this.tableItemStacks[i].writeToNBT(item);
            itemList.appendTag((NBTBase)item);
        }
        tag.setTag("Items", (NBTBase)itemList);
        if (this.hasCustomInventoryName()) {
            tag.setString("CustomName", this.customName);
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int meta = this.getBlockMetadata();
        if ((meta & 8) != 0) {
            return ZERO_EXTENT_AABB;
        }
        int side = meta & 7;
        int xOff = 0;
        int zOff = 0;
        if (side == 2) {
            xOff = 1;
        }
        if (side == 3) {
            xOff = -1;
        }
        if (side == 4) {
            zOff = -1;
        }
        if (side == 5) {
            zOff = 1;
        }
        int xMin = Math.min(this.xCoord, this.xCoord + xOff);
        int xMax = Math.max(this.xCoord, this.xCoord + xOff) + 1;
        int zMin = Math.min(this.zCoord, this.zCoord + zOff);
        int zMax = Math.max(this.zCoord, this.zCoord + zOff) + 1;
        return AxisAlignedBB.getBoundingBox((double)xMin, (double)(this.yCoord + 1), (double)xMax, (double)zMin, (double)(this.yCoord + 2), (double)zMax);
    }
}

