/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.client.renderer.ModularBoxRenderer;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelper;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelperState;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@ThreadSafeISBRH(perThread=true)
public class ControllerRenderer
implements ISimpleBlockRenderingHandler {
    private static final double unit = 0.0625;
    private ModularBoxRenderer boxRenderer = new ModularBoxRenderer();
    private RenderHelper renderHelper = RenderHelper.instances.get();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockController)) {
            return;
        }
        this.renderInventoryBlock((BlockController)block, metadata, modelId, renderer);
    }

    private void renderInventoryBlock(BlockController block, int metadata, int modelId, RenderBlocks renderer) {
        int side = 4;
        this.boxRenderer.setUnit(0.0625);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        for (int i = 0; i < 6; ++i) {
            this.boxRenderer.setIcon(block.getIcon(i, metadata), i);
        }
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.renderHelper.state.setUVRotation(1, RenderHelperState.ROTATION_BY_FACE_FACE[2][side]);
        this.renderExterior(block, 0, 0, 0, side, renderer);
        this.boxRenderer.setUnit(0.0);
        this.boxRenderer.setInteriorIcon(block.getIcon(side, metadata), ForgeDirection.OPPOSITES[side]);
        this.renderInterior(block, 0, 0, 0, side, renderer);
        this.renderHelper.state.clearUVRotation(1);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockController)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockController)block, modelId, renderer);
    }

    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockController block, int modelId, RenderBlocks renderer) {
        TileEntityController tile = block.getTileEntity(world, x, y, z);
        if (tile == null) {
            return false;
        }
        int side = tile.getDirection();
        this.renderHelper.state.setUVRotation(1, RenderHelperState.ROTATION_BY_FACE_FACE[2][side]);
        this.boxRenderer.setUnit(0.0625);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        for (int i = 0; i < 6; ++i) {
            this.boxRenderer.setExteriorIcon(block.getIcon(world, x, y, z, i), i);
        }
        this.boxRenderer.setCutIcon(block.getIconTrim(0));
        this.boxRenderer.setInteriorIcon(block.getIconTrim(0));
        this.renderExterior(block, x, y, z, side, renderer);
        this.boxRenderer.setUnit(0.0);
        this.boxRenderer.setInteriorIcon(block.getIcon(world, x, y, z, side), ForgeDirection.OPPOSITES[side]);
        this.renderInterior(block, x, y, z, side, renderer);
        this.renderHelper.state.clearUVRotation(1);
        return true;
    }

    private void renderExterior(BlockController block, int x, int y, int z, int side, RenderBlocks renderer) {
        double depth = 1.0;
        double xMin = 0.0;
        double xMax = 0.0;
        double zMin = 0.0;
        double zMax = 0.0;
        switch (side) {
            case 2: {
                xMin = 0.0;
                xMax = 1.0;
                zMin = 1.0 - depth;
                zMax = 1.0;
                break;
            }
            case 3: {
                xMin = 0.0;
                xMax = 1.0;
                zMin = 0.0;
                zMax = depth;
                break;
            }
            case 4: {
                xMin = 1.0 - depth;
                xMax = 1.0;
                zMin = 0.0;
                zMax = 1.0;
                break;
            }
            case 5: {
                xMin = 0.0;
                xMax = depth;
                zMin = 0.0;
                zMax = 1.0;
            }
        }
        this.boxRenderer.renderExterior(renderer.blockAccess, (Block)block, x, y, z, xMin, 0.0, zMin, xMax, 1.0, zMax, 0, ModularBoxRenderer.sideCut[side]);
    }

    private void renderInterior(BlockController block, int x, int y, int z, int side, RenderBlocks renderer) {
        double unit = 0.0625;
        double depth = 1.0;
        double xMin = 0.0;
        double xMax = 0.0;
        double zMin = 0.0;
        double zMax = 0.0;
        switch (side) {
            case 2: {
                xMin = unit;
                xMax = 1.0 - unit;
                zMin = 1.0 - depth;
                zMax = 1.0 - depth + unit;
                break;
            }
            case 3: {
                xMin = unit;
                xMax = 1.0 - unit;
                zMin = depth - unit;
                zMax = depth;
                break;
            }
            case 4: {
                xMin = 1.0 - depth;
                xMax = 1.0 - depth + unit;
                zMin = unit;
                zMax = 1.0 - unit;
                break;
            }
            case 5: {
                xMin = depth - unit;
                xMax = depth;
                zMin = unit;
                zMax = 1.0 - unit;
            }
        }
        this.boxRenderer.renderInterior(renderer.blockAccess, (Block)block, x, y, z, xMin, unit, zMin, xMax, 1.0 - unit, zMax, 0, ModularBoxRenderer.sideCut[side]);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return StorageDrawers.proxy.controllerRenderID;
    }
}

