/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.client.renderer.common.CommonFramingRenderer;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelper;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

@ThreadSafeISBRH(perThread=true)
public class FramingTableRenderer
implements ISimpleBlockRenderingHandler {
    private CommonFramingRenderer framingRenderer = new CommonFramingRenderer();
    private RenderHelper renderHelper = RenderHelper.instances.get();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        boolean depthMask;
        if (!(block instanceof BlockFramingTable)) {
            return;
        }
        BlockFramingTable framingTable = (BlockFramingTable)block;
        boolean blendEnabled = GL11.glIsEnabled((int)3042);
        if (blendEnabled) {
            GL11.glDisable((int)3042);
        }
        if (!(depthMask = GL11.glGetBoolean((int)2930))) {
            GL11.glDepthMask((boolean)true);
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.15f, (float)-0.5f, (float)-0.5f);
        GL11.glScalef((float)0.65f, (float)0.65f, (float)0.65f);
        this.renderHelper.state.setUVRotation(1, this.renderHelper.state.rotateTransform);
        this.framingRenderer.renderRight(null, 0, 0, 0, framingTable);
        this.framingRenderer.renderLeft(null, -1, 0, 0, framingTable);
        this.renderHelper.state.clearUVRotation(1);
        if (!blendEnabled) {
            GL11.glDisable((int)3042);
        }
        if (!depthMask) {
            GL11.glDepthMask((boolean)false);
        }
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean right;
        if (!(block instanceof BlockFramingTable)) {
            return false;
        }
        BlockFramingTable framingTable = (BlockFramingTable)block;
        int meta = world.getBlockMetadata(x, y, z);
        int side = meta & 7;
        boolean bl = right = (meta & 8) == 0;
        if (side == 2 || side == 3) {
            right = !right;
        }
        this.renderHelper.state.setRotateTransform(side, 2);
        this.renderHelper.state.setUVRotation(1, this.renderHelper.state.rotateTransform);
        if (ForgeHooksClient.getWorldRenderPass() == 0) {
            if (right) {
                this.framingRenderer.renderRight(world, x, y, z, framingTable);
            } else {
                this.framingRenderer.renderLeft(world, x, y, z, framingTable);
            }
        } else if (ForgeHooksClient.getWorldRenderPass() == 1) {
            if (right) {
                this.framingRenderer.renderOverlayRight(world, x, y, z, framingTable);
            } else {
                this.framingRenderer.renderOverlayLeft(world, x, y, z, framingTable);
            }
        }
        this.renderHelper.state.clearRotateTransform();
        this.renderHelper.state.clearUVRotation(1);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return StorageDrawers.proxy.framingTableRenderID;
    }
}

