/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import net.minecraft.item.ItemStack;

public abstract class InventoryStack {
    private ItemStack inStack;
    private ItemStack outStack;
    private int inCount;
    private int outCount;

    public void init() {
        this.reset();
    }

    public void reset() {
        this.inStack = this.getNewItemStack();
        this.outStack = this.getNewItemStack();
        this.inCount = 0;
        this.outCount = 0;
        this.refresh();
    }

    public ItemStack getInStack() {
        if (this.inStack == null || this.inStack.stackSize == 0) {
            return null;
        }
        return this.inStack;
    }

    public ItemStack getOutStack() {
        return this.outStack;
    }

    public void setInStack(ItemStack stack) {
        if (stack != null) {
            if (this.inStack == null) {
                this.applyDiff(stack.stackSize);
            } else {
                this.applyDiff(stack.stackSize - this.inCount);
            }
        }
        this.inStack = null;
        this.syncInStack();
        this.setOutStack(this.outStack);
    }

    private void syncInStack() {
        if (this.inStack == null) {
            this.inStack = this.getNewItemStack();
            this.inCount = 0;
        }
        if (this.inStack != null) {
            int itemStackLimit = this.getItemStackSize();
            int itemCount = this.getItemCount();
            int remainingLimit = this.getItemCapacity() - itemCount;
            this.inStack.stackSize = this.inCount = itemStackLimit - Math.min(itemStackLimit, remainingLimit);
        }
    }

    public void setOutStack(ItemStack stack) {
        if (this.outStack != null) {
            if (stack == null) {
                this.applyDiff(0 - this.outCount);
            } else {
                this.applyDiff(0 - this.outCount + stack.stackSize);
            }
        }
        this.outStack = stack;
        this.syncOutStack();
    }

    private void syncOutStack() {
        if (this.outStack == null) {
            this.outStack = this.getNewItemStack();
            this.outCount = 0;
        }
        if (this.outStack != null) {
            int itemStackLimit = this.getItemStackSize();
            int itemCount = this.getItemCount();
            this.outStack.stackSize = this.outCount = Math.min(itemStackLimit, itemCount);
        }
    }

    protected abstract ItemStack getNewItemStack();

    protected abstract int getItemStackSize();

    protected abstract int getItemCount();

    protected abstract int getItemCapacity();

    public void markDirty() {
        this.applyDiff(this.getDiff());
        this.refresh();
    }

    public boolean markDirtyIfNeeded() {
        int diff = this.getDiff();
        if (diff != 0) {
            this.applyDiff(diff);
            this.refresh();
            return true;
        }
        return false;
    }

    public int getDiff() {
        int diffIn = (this.inStack == null ? 0 : this.inStack.stackSize) - this.inCount;
        int diffOut = (this.outStack == null ? 0 : this.outStack.stackSize) - this.outCount;
        return diffIn + diffOut;
    }

    protected abstract void applyDiff(int var1);

    protected void refresh() {
        int itemStackLimit = this.getItemStackSize();
        int itemCount = this.getItemCount();
        int remainingLimit = this.getItemCapacity() - itemCount;
        if (this.inStack != null) {
            this.inStack.stackSize = this.inCount = itemStackLimit - Math.min(itemStackLimit, remainingLimit);
        }
        if (this.outStack != null) {
            this.outStack.stackSize = this.outCount = Math.min(itemStackLimit, itemCount);
        }
    }
}

