/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class SlotCraftResult
extends Slot {
    private final IInventory inputInventory;
    private final int[] inputSlots;
    private EntityPlayer player;
    private int amountCrafted;

    public SlotCraftResult(EntityPlayer player, IInventory inputInventory, IInventory inventory, int[] inputSlots, int slot, int x, int y) {
        super(inventory, slot, x, y);
        this.player = player;
        this.inputSlots = inputSlots;
        this.inputInventory = inputInventory;
    }

    public boolean isItemValid(ItemStack stack) {
        return false;
    }

    public ItemStack decrStackSize(int count) {
        if (this.getHasStack()) {
            this.amountCrafted += Math.min(count, this.getStack().stackSize);
        }
        return super.decrStackSize(count);
    }

    protected void onCrafting(ItemStack stack, int count) {
        this.amountCrafted += count;
        super.onCrafting(stack, count);
    }

    protected void onCrafting(ItemStack stack) {
        stack.onCrafting(this.player.worldObj, this.player, this.amountCrafted);
        this.amountCrafted = 0;
    }

    public void onPickupFromSlot(EntityPlayer player, ItemStack itemStack) {
        FMLCommonHandler.instance().firePlayerCraftingEvent(player, itemStack, this.inputInventory);
        this.onCrafting(itemStack);
        for (int slot : this.inputSlots) {
            ItemStack itemTarget = this.inputInventory.getStackInSlot(slot);
            if (itemTarget == null) continue;
            this.inputInventory.decrStackSize(slot, 1);
            if (!itemTarget.getItem().hasContainerItem(itemTarget)) continue;
            ItemStack itemContainer = itemTarget.getItem().getContainerItem(itemTarget);
            if (itemContainer != null && itemContainer.isItemStackDamageable() && itemContainer.getItemDamage() > itemContainer.getMaxDamage()) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(this.player, itemContainer));
                continue;
            }
            if (itemTarget.getItem().doesContainerItemLeaveCraftingGrid(itemTarget) && this.player.inventory.addItemStackToInventory(itemContainer)) continue;
            if (this.inputInventory.getStackInSlot(slot) == null) {
                this.inputInventory.setInventorySlotContents(slot, itemContainer);
                continue;
            }
            this.player.dropPlayerItemWithRandomChoice(itemContainer, false);
        }
    }
}

