/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ISealable;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemTape
extends Item {
    public ItemTape(String name) {
        this.setUnlocalizedName(name);
        this.setMaxStackSize(1);
        this.setMaxDamage(8);
        this.setTextureName("StorageDrawers:tape_roll");
        this.setCreativeTab(ModCreativeTabs.tabStorageDrawers);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        String name = this.getUnlocalizedName(itemStack);
        list.add(StatCollector.translateToLocalFormatted((String)(name + ".description"), (Object[])new Object[0]));
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!player.canPlayerEdit(x, y, z, side, stack)) {
            return false;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IProtectable && !SecurityManager.hasOwnership(player.getGameProfile(), (IProtectable)tile)) {
            return false;
        }
        if (tile instanceof ISealable) {
            ISealable tileseal = (ISealable)tile;
            if (tileseal.isSealed()) {
                return false;
            }
            tileseal.setIsSealed(true);
            stack.damageItem(1, (EntityLivingBase)player);
            return true;
        }
        return false;
    }
}

