/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;

public class ItemUpgradeStatus
extends Item {
    public static final String[] iconNames = new String[]{null, "level1", "level2"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemUpgradeStatus(String name) {
        this.setUnlocalizedName(name);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setCreativeTab(ModCreativeTabs.tabStorageDrawers);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int meta) {
        return this.icons[MathHelper.clamp_int((int)meta, (int)0, (int)(iconNames.length - 1))];
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        int meta = MathHelper.clamp_int((int)itemStack.getItemDamage(), (int)0, (int)(iconNames.length - 1));
        if (iconNames[meta] == null) {
            return super.getUnlocalizedName();
        }
        return super.getUnlocalizedName() + "." + iconNames[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        String name = this.getUnlocalizedName(itemStack);
        list.add(StatCollector.translateToLocalFormatted((String)(name + ".description"), (Object[])new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs creativeTabs, List list) {
        int n = iconNames.length;
        for (int i = 0; i < n; ++i) {
            if (iconNames[i] == null) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new IIcon[iconNames.length];
        int n = iconNames.length;
        for (int i = 0; i < n; ++i) {
            if (iconNames[i] == null) continue;
            this.icons[i] = register.registerIcon("StorageDrawers:upgrade_status_" + iconNames[i]);
        }
    }
}

