/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.packs.forestry.core;

import com.jaquadro.minecraft.storagedrawers.api.IStorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.api.StorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.api.config.IBlockConfig;
import com.jaquadro.minecraft.storagedrawers.api.config.IUserConfig;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackBlockFactory;
import com.jaquadro.minecraft.storagedrawers.packs.forestry.StorageDrawersPack;
import com.jaquadro.minecraft.storagedrawers.packs.forestry.core.DataResolver;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;

public class ModBlocks {
    public static Block[] fullDrawers1;
    public static Block[] fullDrawers2;
    public static Block[] fullDrawers4;
    public static Block[] halfDrawers2;
    public static Block[] halfDrawers4;
    public static Block[] trim;

    public void init() {
        int i;
        IStorageDrawersApi api = StorageDrawersApi.instance();
        if (api == null) {
            return;
        }
        IPackBlockFactory factory = api.packFactory();
        DataResolver[] resolvers = StorageDrawersPack.instance.resolvers;
        fullDrawers1 = new Block[resolvers.length];
        fullDrawers2 = new Block[resolvers.length];
        fullDrawers4 = new Block[resolvers.length];
        halfDrawers2 = new Block[resolvers.length];
        halfDrawers4 = new Block[resolvers.length];
        trim = new Block[resolvers.length];
        for (int i2 = 0; i2 < resolvers.length; ++i2) {
            DataResolver resolver = resolvers[i2];
            ModBlocks.fullDrawers1[i2] = factory.createBlock(BlockConfiguration.BasicFull1, resolver);
            ModBlocks.fullDrawers2[i2] = factory.createBlock(BlockConfiguration.BasicFull2, resolver);
            ModBlocks.fullDrawers4[i2] = factory.createBlock(BlockConfiguration.BasicFull4, resolver);
            ModBlocks.halfDrawers2[i2] = factory.createBlock(BlockConfiguration.BasicHalf2, resolver);
            ModBlocks.halfDrawers4[i2] = factory.createBlock(BlockConfiguration.BasicHalf4, resolver);
            ModBlocks.trim[i2] = factory.createBlock(BlockConfiguration.Trim, resolver);
        }
        IUserConfig config = api.userConfig();
        IBlockConfig blockConfig = config.blockConfig();
        char[] tail = new char[]{'A', 'B'};
        if (blockConfig.isBlockEnabled(blockConfig.getBlockConfigName(BlockConfiguration.BasicFull1))) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.registerBlock(fullDrawers1[i], "fullDrawers1" + tail[i]);
            }
        }
        if (blockConfig.isBlockEnabled(blockConfig.getBlockConfigName(BlockConfiguration.BasicFull2))) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.registerBlock(fullDrawers2[i], "fullDrawers2" + tail[i]);
            }
        }
        if (blockConfig.isBlockEnabled(blockConfig.getBlockConfigName(BlockConfiguration.BasicFull4))) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.registerBlock(fullDrawers4[i], "fullDrawers4" + tail[i]);
            }
        }
        if (blockConfig.isBlockEnabled(blockConfig.getBlockConfigName(BlockConfiguration.BasicHalf2))) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.registerBlock(halfDrawers2[i], "halfDrawers2" + tail[i]);
            }
        }
        if (blockConfig.isBlockEnabled(blockConfig.getBlockConfigName(BlockConfiguration.BasicHalf4))) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.registerBlock(halfDrawers4[i], "halfDrawers4" + tail[i]);
            }
        }
        if (blockConfig.isBlockEnabled(blockConfig.getBlockConfigName(BlockConfiguration.Trim))) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.registerBlock(trim[i], "trim" + tail[i]);
            }
        }
        if (!config.addonConfig().showAddonItemsNEI()) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.hideBlock(ModBlocks.getQualifiedName(fullDrawers1[i]));
                factory.hideBlock(ModBlocks.getQualifiedName(fullDrawers2[i]));
                factory.hideBlock(ModBlocks.getQualifiedName(fullDrawers4[i]));
                factory.hideBlock(ModBlocks.getQualifiedName(halfDrawers2[i]));
                factory.hideBlock(ModBlocks.getQualifiedName(halfDrawers4[i]));
                factory.hideBlock(ModBlocks.getQualifiedName(trim[i]));
            }
        }
    }

    public static String getQualifiedName(Block block) {
        return GameData.getBlockRegistry().getNameForObject((Object)block);
    }
}

