/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.storage;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.storage.IStorageProvider;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.tileentity.TileEntity;

public class DefaultStorageProvider
implements IStorageProvider {
    TileEntity tile;
    IDrawerGroup group;

    public DefaultStorageProvider(TileEntity tileEntity, IDrawerGroup drawerGroup) {
        this.tile = tileEntity;
        this.group = drawerGroup;
    }

    @Override
    public boolean isCentrallyManaged() {
        return false;
    }

    @Override
    public int getSlotCount(int slot) {
        return 0;
    }

    @Override
    public void setSlotCount(int slot, int amount) {
    }

    @Override
    public int getSlotStackCapacity(int slot) {
        return 0;
    }

    @Override
    public boolean isLocked(int slot, LockAttribute attr) {
        return false;
    }

    @Override
    public boolean isVoid(int slot) {
        return false;
    }

    @Override
    public boolean isShrouded(int slot) {
        return false;
    }

    @Override
    public boolean isDowngraded(int slot) {
        return false;
    }

    @Override
    public boolean setIsShrouded(int slot, boolean state) {
        return false;
    }

    @Override
    public boolean isQuantified(int slot) {
        return false;
    }

    @Override
    public boolean setIsQuantified(int slot, boolean state) {
        return false;
    }

    @Override
    public boolean isStorageUnlimited(int slot) {
        return false;
    }

    @Override
    public boolean isVendingUnlimited(int slot) {
        return false;
    }

    @Override
    public boolean isRedstone(int slot) {
        return false;
    }

    @Override
    public void markAmountDirty(int slot) {
        if (this.tile.getWorldObj().isRemote) {
            return;
        }
        int count = this.group.getDrawer(slot).getStoredItemCount();
        CountUpdateMessage message = new CountUpdateMessage(this.tile.xCoord, this.tile.yCoord, this.tile.zCoord, slot, count);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(this.tile.getWorldObj().provider.dimensionId, (double)this.tile.xCoord, (double)this.tile.yCoord, (double)this.tile.zCoord, 500.0);
        StorageDrawers.network.sendToAllAround((IMessage)message, targetPoint);
        this.tile.getWorldObj().markTileEntityChunkModified(this.tile.xCoord, this.tile.yCoord, this.tile.zCoord, this.tile);
        if (this.isRedstone(slot)) {
            this.tile.getWorldObj().notifyBlocksOfNeighborChange(this.tile.xCoord, this.tile.yCoord, this.tile.zCoord, this.tile.getBlockType());
            this.tile.getWorldObj().notifyBlocksOfNeighborChange(this.tile.xCoord, this.tile.yCoord - 1, this.tile.zCoord, this.tile.getBlockType());
        }
    }

    @Override
    public void markDirty(int slot) {
        if (this.tile.getWorldObj().isRemote) {
            return;
        }
        this.tile.getWorldObj().markBlockForUpdate(this.tile.xCoord, this.tile.yCoord, this.tile.zCoord);
        this.tile.getWorldObj().markTileEntityChunkModified(this.tile.xCoord, this.tile.yCoord, this.tile.zCoord, this.tile);
    }
}

