/*
 * Decompiled with CFR 0.152.
 */
package grainalcohol.smart_absorption.mixin;

import grainalcohol.smart_absorption.AbsorptionAccessor;
import net.minecraft.class_1282;
import net.minecraft.class_1288;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements AbsorptionAccessor {
    @Unique
    private float statusEffectAbsorptionAmount = 0.0f;

    @Override
    public float smartAbsorption$getStatusEffectAbsorptionAmount() {
        return this.statusEffectAbsorptionAmount;
    }

    @Override
    public void smartAbsorption$setStatusEffectAbsorptionAmount(float amount) {
        this.statusEffectAbsorptionAmount = Math.max(0.0f, amount);
    }

    @Override
    public void smartAbsorption$addStatusEffectAbsorptionAmount(float amount) {
        this.smartAbsorption$setStatusEffectAbsorptionAmount(this.smartAbsorption$getStatusEffectAbsorptionAmount() + amount);
    }

    @Inject(method={"setAbsorptionAmount"}, at={@At(value="TAIL")})
    private void onSetAbsorptionAmount(float amount, CallbackInfo ci) {
        float amount1 = Math.max(0.0f, amount);
        if (amount1 < this.smartAbsorption$getStatusEffectAbsorptionAmount()) {
            this.smartAbsorption$setStatusEffectAbsorptionAmount(amount1);
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setAbsorptionAmount(F)V", shift=At.Shift.AFTER, ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void modifyWhenDamage(class_1282 source, float amount, CallbackInfo ci, float f) {
        this.smartAbsorption$addStatusEffectAbsorptionAmount(-(f - amount));
        if (this.smartAbsorption$getStatusEffectAbsorptionAmount() <= 0.0f) {
            ((class_1309)this).method_6016(class_1294.field_5898);
        }
    }

    @Inject(method={"onStatusEffectApplied"}, at={@At(value="HEAD")})
    private void modifyWhenApplied(class_1293 effect, class_1297 source, CallbackInfo ci) {
        if (!((class_1309)this).method_37908().method_8608() && effect.method_5579() instanceof class_1288) {
            this.smartAbsorption$setStatusEffectAbsorptionAmount((effect.method_5578() + 1) * 4);
        }
    }

    @Inject(method={"onStatusEffectRemoved"}, at={@At(value="HEAD")})
    private void modifyWhenRemoved(class_1293 effect, CallbackInfo ci) {
        if (!((class_1309)this).method_37908().method_8608() && effect.method_5579() instanceof class_1288) {
            this.smartAbsorption$setStatusEffectAbsorptionAmount(0.0f);
        }
    }

    @Inject(method={"onStatusEffectUpgraded"}, at={@At(value="HEAD")})
    private void modifyWhenUpgraded(class_1293 effect, boolean reapplyEffect, class_1297 source, CallbackInfo ci) {
        if (!((class_1309)this).method_37908().method_8608() && effect.method_5579() instanceof class_1288) {
            this.smartAbsorption$setStatusEffectAbsorptionAmount((effect.method_5578() + 1) * 4);
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="HEAD")})
    private void writeStatusEffectAbsorptionToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10548("StatusEffectAbsorption", this.smartAbsorption$getStatusEffectAbsorptionAmount());
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    private void readStatusEffectAbsorptionFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("StatusEffectAbsorption")) {
            this.smartAbsorption$setStatusEffectAbsorptionAmount(nbt.method_10583("StatusEffectAbsorption"));
        }
    }
}

