/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.api;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.database.MySQLDatabase;
import dev.faultyfunctions.soulgraves.managers.DatabaseManagerKt;
import dev.faultyfunctions.soulgraves.managers.StorageType;
import dev.faultyfunctions.soulgraves.utils.Soul;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\bJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\fJ\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b2\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006\u00a8\u0006\u0014"}, d2={"Ldev/faultyfunctions/soulgraves/api/SoulGravesAPI;", "", "<init>", "()V", "getAllSouls", "", "Ldev/faultyfunctions/soulgraves/utils/Soul;", "getAllSoulsCrossServer", "Ljava/util/concurrent/CompletableFuture;", "", "getPlayerSouls", "ownerUUID", "Ljava/util/UUID;", "getPlayerSoulsCrossServer", "getSoul", "makerUUID", "getSoulCrossServer", "makeExplosion", "", "soul", "soulgraves"})
public final class SoulGravesAPI {
    @NotNull
    public static final SoulGravesAPI INSTANCE = new SoulGravesAPI();

    private SoulGravesAPI() {
    }

    @NotNull
    public final List<Soul> getAllSouls() {
        return SoulGraves.Companion.getSoulList();
    }

    @NotNull
    public final CompletableFuture<List<Soul>> getAllSoulsCrossServer() {
        if (DatabaseManagerKt.getSTORAGE_MODE() == StorageType.PDC) {
            throw new RuntimeException("DO NOT USE CROSS-SERVER API WITH PDC STORAGE MODE!");
        }
        CompletableFuture future = new CompletableFuture();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> SoulGravesAPI.getAllSoulsCrossServer$lambda$0(future));
        CompletableFuture<List<Soul>> completableFuture = future.orTimeout(5L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(completableFuture, "orTimeout(...)");
        return completableFuture;
    }

    @NotNull
    public final List<Soul> getPlayerSouls(@NotNull UUID ownerUUID) {
        Intrinsics.checkNotNullParameter(ownerUUID, "ownerUUID");
        List souls = new ArrayList();
        Iterator<Soul> iterator2 = SoulGraves.Companion.getSoulList().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Soul> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Soul soul = iterator3.next();
            if (!Intrinsics.areEqual(soul.getOwnerUUID(), ownerUUID)) continue;
            Intrinsics.checkNotNull(soul);
            souls.add(soul);
        }
        return souls;
    }

    @NotNull
    public final CompletableFuture<List<Soul>> getPlayerSoulsCrossServer(@NotNull UUID ownerUUID) {
        Intrinsics.checkNotNullParameter(ownerUUID, "ownerUUID");
        if (DatabaseManagerKt.getSTORAGE_MODE() == StorageType.PDC) {
            throw new RuntimeException("DO NOT USE CROSS-SERVER API WITH PDC STORAGE MODE!");
        }
        CompletableFuture future = new CompletableFuture();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> SoulGravesAPI.getPlayerSoulsCrossServer$lambda$1(ownerUUID, future));
        CompletableFuture<List<Soul>> completableFuture = future.orTimeout(5L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(completableFuture, "orTimeout(...)");
        return completableFuture;
    }

    @Nullable
    public final Soul getSoul(@NotNull UUID makerUUID) {
        Intrinsics.checkNotNullParameter(makerUUID, "makerUUID");
        Iterator<Soul> iterator2 = SoulGraves.Companion.getSoulList().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Soul> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Soul soul = iterator3.next();
            if (!Intrinsics.areEqual(soul.getMarkerUUID(), makerUUID)) continue;
            return soul;
        }
        return null;
    }

    @NotNull
    public final CompletableFuture<Soul> getSoulCrossServer(@NotNull UUID makerUUID) {
        Intrinsics.checkNotNullParameter(makerUUID, "makerUUID");
        if (DatabaseManagerKt.getSTORAGE_MODE() == StorageType.PDC) {
            throw new RuntimeException("DO NOT USE CROSS-SERVER API WITH PDC STORAGE MODE!");
        }
        CompletableFuture future = new CompletableFuture();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> SoulGravesAPI.getSoulCrossServer$lambda$2(makerUUID, future));
        CompletableFuture<Soul> completableFuture = future.orTimeout(5L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(completableFuture, "orTimeout(...)");
        return completableFuture;
    }

    public final void makeExplosion(@NotNull Soul soul) {
        Intrinsics.checkNotNullParameter(soul, "soul");
        soul.explode();
    }

    private static final void getAllSoulsCrossServer$lambda$0(CompletableFuture $future) {
        List<Soul> allSouls = MySQLDatabase.Companion.getInstance().getAllSouls();
        $future.complete(allSouls);
    }

    private static final void getPlayerSoulsCrossServer$lambda$1(UUID $ownerUUID, CompletableFuture $future) {
        List<Soul> allSouls = MySQLDatabase.Companion.getInstance().getPlayerSouls($ownerUUID);
        $future.complete(allSouls);
    }

    private static final void getSoulCrossServer$lambda$2(UUID $makerUUID, CompletableFuture $future) {
        Soul soul = MySQLDatabase.Companion.getInstance().getSoul($makerUUID);
        $future.complete(soul);
    }
}

