/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.commands;

import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.api.SoulGravesAPI;
import dev.faultyfunctions.soulgraves.compatibilities.VaultHook;
import dev.faultyfunctions.soulgraves.database.MessageAction;
import dev.faultyfunctions.soulgraves.database.RedisDatabase;
import dev.faultyfunctions.soulgraves.database.RedisPacket;
import dev.faultyfunctions.soulgraves.libs.lamp.annotation.Description;
import dev.faultyfunctions.soulgraves.libs.lamp.annotation.Subcommand;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.annotation.CommandPermission;
import dev.faultyfunctions.soulgraves.libs.lamp.orphan.OrphanCommand;
import dev.faultyfunctions.soulgraves.managers.ConfigManager;
import dev.faultyfunctions.soulgraves.managers.DatabaseManagerKt;
import dev.faultyfunctions.soulgraves.managers.MessageManager;
import dev.faultyfunctions.soulgraves.managers.StorageType;
import dev.faultyfunctions.soulgraves.messengers.PluginConnectMessenger;
import dev.faultyfunctions.soulgraves.utils.Soul;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Ldev/faultyfunctions/soulgraves/commands/BackCommand;", "Ldev/faultyfunctions/soulgraves/libs/lamp/orphan/OrphanCommand;", "<init>", "()V", "backCommand", "", "sender", "Lorg/bukkit/entity/Player;", "soulgraves"})
@SourceDebugExtension(value={"SMAP\nBackCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackCommand.kt\ndev/faultyfunctions/soulgraves/commands/BackCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1062#2:129\n*S KotlinDebug\n*F\n+ 1 BackCommand.kt\ndev/faultyfunctions/soulgraves/commands/BackCommand\n*L\n33#1:129\n*E\n"})
public final class BackCommand
implements OrphanCommand {
    @Subcommand(value={"back"})
    @Description(value="Returns a player to their last soul location")
    @CommandPermission(value="soulgraves.command.back")
    public final void backCommand(@NotNull Player sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SoulGraves.Companion.getPlugin(), () -> BackCommand.backCommand$lambda$17(sender));
    }

    private static final void backCommand$lambda$17$lambda$7$lambda$2$lambda$1(Player $sender, Component $it) {
        SoulGraves.Companion.getPlugin().adventure().player($sender).sendMessage($it);
    }

    private static final void backCommand$lambda$17$lambda$7$lambda$6(Player $sender, Soul $newestSoul) {
        block3: {
            block4: {
                block2: {
                    if (ConfigManager.INSTANCE.getTeleportCost().compareTo(BigDecimal.ZERO) > 0) break block2;
                    Component component = MessageManager.INSTANCE.getCommandBackSuccessFree();
                    if (component != null) {
                        Component it = component;
                        boolean bl = false;
                        SoulGraves.Companion.getPlugin().adventure().player($sender).sendMessage(it);
                    }
                    $sender.teleport($newestSoul.getLocation());
                    break block3;
                }
                if (!VaultHook.INSTANCE.has($sender, ConfigManager.INSTANCE.getTeleportCost())) break block4;
                VaultHook.INSTANCE.withdraw($sender, ConfigManager.INSTANCE.getTeleportCost());
                Component component = MessageManager.INSTANCE.getCommandBackSuccessPaid();
                if (component != null) {
                    Component it = component;
                    boolean bl = false;
                    SoulGraves.Companion.getPlugin().adventure().player($sender).sendMessage(it);
                }
                $sender.teleport($newestSoul.getLocation());
                break block3;
            }
            Component component = MessageManager.INSTANCE.getCommandBackNoFundsComponent();
            if (component == null) break block3;
            Component it = component;
            boolean bl = false;
            SoulGraves.Companion.getPlugin().adventure().player($sender).sendMessage(it);
        }
    }

    private static final void backCommand$lambda$17$lambda$15$lambda$9$lambda$8(Player $sender, Component $it) {
        SoulGraves.Companion.getPlugin().adventure().player($sender).sendMessage($it);
    }

    private static final void backCommand$lambda$17$lambda$15$lambda$14(Soul $newestSoul, Player $sender) {
        if (Intrinsics.areEqual($newestSoul.getServerId(), DatabaseManagerKt.getSERVER_NAME())) {
            if (ConfigManager.INSTANCE.getTeleportCost().compareTo(BigDecimal.ZERO) <= 0) {
                Component component = MessageManager.INSTANCE.getCommandBackSuccessFree();
                if (component != null) {
                    Component it = component;
                    boolean bl = false;
                    SoulGraves.Companion.getPlugin().adventure().player($sender).sendMessage(it);
                }
                $sender.teleport($newestSoul.getLocation());
            } else {
                VaultHook vaultHook = VaultHook.INSTANCE;
                boolean bl = false;
                if (vaultHook.has($sender, ConfigManager.INSTANCE.getTeleportCost())) {
                    vaultHook.withdraw($sender, ConfigManager.INSTANCE.getTeleportCost());
                    Component component = MessageManager.INSTANCE.getCommandBackSuccessPaid();
                    if (component != null) {
                        Component it = component;
                        boolean bl2 = false;
                        SoulGraves.Companion.getPlugin().adventure().player($sender).sendMessage(it);
                    }
                    $sender.teleport($newestSoul.getLocation());
                } else {
                    Component component = MessageManager.INSTANCE.getCommandBackNoFundsComponent();
                    if (component != null) {
                        Component it = component;
                        boolean bl3 = false;
                        SoulGraves.Companion.getPlugin().adventure().player($sender).sendMessage(it);
                    }
                }
            }
        } else {
            PluginConnectMessenger.INSTANCE.sendConnectMessage($sender, $newestSoul.getServerId());
            Location loc = $newestSoul.getLocation();
            World world = loc.getWorld();
            String payload = $sender.getUniqueId() + "|" + (world != null ? world.getName() : null) + "|" + loc.getX() + "|" + loc.getY() + "|" + loc.getZ();
            RedisDatabase.Companion.getInstance().publish(new RedisPacket(DatabaseManagerKt.getSERVER_NAME(), MessageAction.TELEPORT_TO_SOUL, payload));
        }
    }

    private static final Unit backCommand$lambda$17$lambda$15(Player $sender, List souls) {
        if (souls.isEmpty()) {
            Component component = MessageManager.INSTANCE.getCommandBackNoSoulComponent();
            if (component != null) {
                Component it = component;
                boolean bl = false;
                Bukkit.getScheduler().runTask((Plugin)SoulGraves.Companion.getPlugin(), () -> BackCommand.backCommand$lambda$17$lambda$15$lambda$9$lambda$8($sender, it));
            }
            return Unit.INSTANCE;
        }
        Intrinsics.checkNotNull(souls);
        Soul newestSoul = (Soul)CollectionsKt.first(souls);
        Bukkit.getScheduler().runTask((Plugin)SoulGraves.Companion.getPlugin(), () -> BackCommand.backCommand$lambda$17$lambda$15$lambda$14(newestSoul, $sender));
        return Unit.INSTANCE;
    }

    private static final void backCommand$lambda$17$lambda$16(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void backCommand$lambda$17(Player $sender) {
        switch (WhenMappings.$EnumSwitchMapping$0[DatabaseManagerKt.getSTORAGE_MODE().ordinal()]) {
            case 1: {
                UUID uUID = $sender.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                List<Soul> souls = SoulGravesAPI.INSTANCE.getPlayerSouls(uUID);
                boolean bl = false;
                Iterable $this$sortedByDescending$iv = souls;
                boolean $i$f$sortedByDescending = false;
                List sorted2 = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Soul it = (Soul)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getExpireTime());
                        it = (Soul)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getExpireTime());
                    }
                });
                if (sorted2.isEmpty()) {
                    Component component = MessageManager.INSTANCE.getCommandBackNoSoulComponent();
                    if (component != null) {
                        Component it = component;
                        boolean bl2 = false;
                        Bukkit.getScheduler().runTask((Plugin)SoulGraves.Companion.getPlugin(), () -> BackCommand.backCommand$lambda$17$lambda$7$lambda$2$lambda$1($sender, it));
                    }
                    return;
                }
                Soul newestSoul = (Soul)CollectionsKt.first(sorted2);
                Bukkit.getScheduler().runTask((Plugin)SoulGraves.Companion.getPlugin(), () -> BackCommand.backCommand$lambda$17$lambda$7$lambda$6($sender, newestSoul));
                break;
            }
            case 2: {
                UUID uUID = $sender.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                CompletableFuture<List<Soul>> future = SoulGravesAPI.INSTANCE.getPlayerSoulsCrossServer(uUID);
                future.thenAccept(arg_0 -> BackCommand.backCommand$lambda$17$lambda$16(arg_0 -> BackCommand.backCommand$lambda$17$lambda$15($sender, arg_0), arg_0));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StorageType.values().length];
            try {
                nArray[StorageType.PDC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageType.CROSS_SERVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

