/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.compatibilities;

import dev.faultyfunctions.soulgraves.SoulGraves;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/faultyfunctions/soulgraves/compatibilities/VaultHook;", "", "<init>", "()V", "economy", "isVaultUnlocked", "", "init", "", "withdraw", "player", "Lorg/bukkit/entity/Player;", "amount", "Ljava/math/BigDecimal;", "has", "soulgraves"})
public final class VaultHook {
    @NotNull
    public static final VaultHook INSTANCE = new VaultHook();
    @Nullable
    private static Object economy;
    private static boolean isVaultUnlocked;

    private VaultHook() {
    }

    public final void init() {
        RegisteredServiceProvider rsp;
        try {
            Class<?> vaultUnlockedClass = Class.forName("net.milkbowl.vault2.economy.Economy");
            rsp = SoulGraves.Companion.getPlugin().getServer().getServicesManager().getRegistration(vaultUnlockedClass);
            if (rsp != null) {
                economy = rsp.getProvider();
                isVaultUnlocked = true;
                SoulGraves.Companion.getPlugin().getLogger().info("[\u221a] VaultUnlocked hook loaded!");
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            SoulGraves.Companion.getPlugin().getLogger().info("[!] VaultUnlocked not detected, trying regular Vault...");
        }
        catch (Exception ex) {
            SoulGraves.Companion.getPlugin().getLogger().warning("[X] Error trying to hook into VaultUnlocked: " + ex.getMessage());
        }
        try {
            Class<?> vaultClass = Class.forName("net.milkbowl.vault.economy.Economy");
            rsp = SoulGraves.Companion.getPlugin().getServer().getServicesManager().getRegistration(vaultClass);
            if (rsp != null) {
                economy = rsp.getProvider();
                isVaultUnlocked = false;
                SoulGraves.Companion.getPlugin().getLogger().info("[\u221a] Vault hook loaded!");
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            SoulGraves.Companion.getPlugin().getLogger().warning("[X] Vault class not found");
        }
        catch (Exception ex) {
            SoulGraves.Companion.getPlugin().getLogger().warning("[X] Error trying to hook into Vault: " + ex.getMessage());
        }
        SoulGraves.Companion.getPlugin().getLogger().warning("[X] No economy provider found! Neither VaultUnlocked nor Vault could be hooked.");
    }

    public final boolean withdraw(@NotNull Player player, @NotNull BigDecimal amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(amount, "amount");
        if (economy == null) {
            return false;
        }
        if (isVaultUnlocked) {
            boolean bl2;
            Object object = economy;
            Intrinsics.checkNotNull(object);
            Object vaultUnlockedEcon = object;
            try {
                Class[] classArray = new Class[]{String.class, UUID.class, BigDecimal.class};
                Method withdrawMethod = vaultUnlockedEcon.getClass().getMethod("withdraw", classArray);
                Object[] objectArray = new Object[]{SoulGraves.Companion.getPlugin().getName(), player.getUniqueId(), amount};
                Object result = withdrawMethod.invoke(vaultUnlockedEcon, objectArray);
                Method transactionSuccessMethod = result.getClass().getMethod("transactionSuccess", new Class[0]);
                Object object2 = transactionSuccessMethod.invoke(result, new Object[0]);
                Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Boolean");
                bl2 = (Boolean)object2;
            }
            catch (Exception ex) {
                SoulGraves.Companion.getPlugin().getLogger().warning("[X] Error using VaultUnlocked economy: " + ex.getMessage());
                bl2 = false;
            }
            bl = bl2;
        } else {
            Object object = economy;
            Economy economy = object instanceof Economy ? (Economy)object : null;
            bl = economy != null && (economy = economy.withdrawPlayer((OfflinePlayer)player, amount.doubleValue())) != null ? economy.transactionSuccess() : false;
        }
        return bl;
    }

    public final boolean has(@NotNull Player player, @NotNull BigDecimal amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(amount, "amount");
        if (economy == null) {
            return false;
        }
        if (isVaultUnlocked) {
            boolean bl2;
            Object object = economy;
            Intrinsics.checkNotNull(object);
            Object vaultUnlockedEcon = object;
            try {
                Class[] classArray = new Class[]{String.class, UUID.class, BigDecimal.class};
                Method hasMethod = vaultUnlockedEcon.getClass().getMethod("has", classArray);
                Object[] objectArray = new Object[]{SoulGraves.Companion.getPlugin().getName(), player.getUniqueId(), amount};
                Object object2 = hasMethod.invoke(vaultUnlockedEcon, objectArray);
                Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Boolean");
                bl2 = (Boolean)object2;
            }
            catch (Exception ex) {
                SoulGraves.Companion.getPlugin().getLogger().warning("[X] Error using VaultUnlocked economy: " + ex.getMessage());
                bl2 = false;
            }
            bl = bl2;
        } else {
            Object object = economy;
            Economy economy = object instanceof Economy ? (Economy)object : null;
            bl = economy != null ? economy.has((OfflinePlayer)player, amount.doubleValue()) : false;
        }
        return bl;
    }
}

