/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.compatibilities;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.api.event.SoulPreSpawnEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Ldev/faultyfunctions/soulgraves/compatibilities/WorldGuardHook;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "registry", "Lcom/sk89q/worldguard/protection/flags/registry/FlagRegistry;", "getRegistry", "()Lcom/sk89q/worldguard/protection/flags/registry/FlagRegistry;", "setRegistry", "(Lcom/sk89q/worldguard/protection/flags/registry/FlagRegistry;)V", "flagRegisteredSuccess", "", "getFlagRegisteredSuccess", "()Z", "setFlagRegisteredSuccess", "(Z)V", "soulGravesSpawningFlag", "Lcom/sk89q/worldguard/protection/flags/StateFlag;", "getSoulGravesSpawningFlag", "()Lcom/sk89q/worldguard/protection/flags/StateFlag;", "setSoulGravesSpawningFlag", "(Lcom/sk89q/worldguard/protection/flags/StateFlag;)V", "registerFlags", "", "init", "onSoulPreSpawn", "e", "Ldev/faultyfunctions/soulgraves/api/event/SoulPreSpawnEvent;", "soulgraves"})
public final class WorldGuardHook
implements Listener {
    @NotNull
    public static final WorldGuardHook INSTANCE = new WorldGuardHook();
    @NotNull
    private static FlagRegistry registry;
    private static boolean flagRegisteredSuccess;
    @Nullable
    private static StateFlag soulGravesSpawningFlag;

    private WorldGuardHook() {
    }

    @NotNull
    public final FlagRegistry getRegistry() {
        return registry;
    }

    public final void setRegistry(@NotNull FlagRegistry flagRegistry) {
        Intrinsics.checkNotNullParameter(flagRegistry, "<set-?>");
        registry = flagRegistry;
    }

    public final boolean getFlagRegisteredSuccess() {
        return flagRegisteredSuccess;
    }

    public final void setFlagRegisteredSuccess(boolean bl) {
        flagRegisteredSuccess = bl;
    }

    @Nullable
    public final StateFlag getSoulGravesSpawningFlag() {
        return soulGravesSpawningFlag;
    }

    public final void setSoulGravesSpawningFlag(@Nullable StateFlag stateFlag) {
        soulGravesSpawningFlag = stateFlag;
    }

    public final void registerFlags() {
        try {
            StateFlag flag = new StateFlag("soulgraves-spawning", true);
            registry.register((Flag)flag);
            soulGravesSpawningFlag = flag;
            flagRegisteredSuccess = true;
        }
        catch (FlagConflictException flagConflictException) {
            Flag existing = registry.get("my-custom-flag");
            if (existing instanceof StateFlag) {
                soulGravesSpawningFlag = (StateFlag)existing;
                flagRegisteredSuccess = true;
            }
            flagRegisteredSuccess = false;
            return;
        }
    }

    public final void init() {
        if (!flagRegisteredSuccess) {
            SoulGraves.Companion.getPlugin().getLogger().warning("WorldGuard has registered the soulgraves-spawning flag!");
            return;
        }
        SoulGraves.Companion.getPlugin().getServer().getPluginManager().registerEvents((Listener)INSTANCE, (Plugin)SoulGraves.Companion.getPlugin());
        SoulGraves.Companion.getPlugin().getLogger().info("[\u221a] WorldGuard Hooked!");
    }

    @EventHandler
    public final void onSoulPreSpawn(@NotNull SoulPreSpawnEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, "e");
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(e.getDeathEvent().getEntity());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet regions = query.getApplicableRegions(localPlayer.getLocation());
        StateFlag.State value = (StateFlag.State)regions.queryValue((RegionAssociable)localPlayer, (Flag)soulGravesSpawningFlag);
        if (value == StateFlag.State.DENY) {
            e.setCancelled(true);
        }
    }

    static {
        FlagRegistry flagRegistry = WorldGuard.getInstance().getFlagRegistry();
        Intrinsics.checkNotNullExpressionValue(flagRegistry, "getFlagRegistry(...)");
        registry = flagRegistry;
    }
}

