/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import dev.faultyfunctions.soulgraves.SoulGraves;
import dev.faultyfunctions.soulgraves.libs.boostedyaml.YamlDocument;
import dev.faultyfunctions.soulgraves.libs.rtag.item.ItemTagStream;
import dev.faultyfunctions.soulgraves.managers.ConfigManager;
import dev.faultyfunctions.soulgraves.managers.DatabaseManager;
import dev.faultyfunctions.soulgraves.managers.DatabaseManagerKt;
import dev.faultyfunctions.soulgraves.utils.Soul;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u0017J\u001e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0017J\u000e\u0010 \u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0017J\u000e\u0010!\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010!\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/faultyfunctions/soulgraves/database/MySQLDatabase;", "", "<init>", "()V", "dataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "jdbcUrl", "", "jdbcDriver", "username", "password", "databaseName", "createTable", "", "initCurrentServerSouls", "saveSoul", "soul", "Ldev/faultyfunctions/soulgraves/utils/Soul;", "saveSoulCopy", "getAllSouls", "", "getPlayerSouls", "playerUUID", "Ljava/util/UUID;", "getSoul", "markerUUID", "updateSoulFreezeTime", "makerUUID", "freezeTime", "", "expireTime", "markSoulDelete", "markSoulExplode", "deleteSoul", "Companion", "soulgraves"})
@SourceDebugExtension(value={"SMAP\nMySQLDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MySQLDatabase.kt\ndev/faultyfunctions/soulgraves/database/MySQLDatabase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,434:1\n774#2:435\n865#2,2:436\n*S KotlinDebug\n*F\n+ 1 MySQLDatabase.kt\ndev/faultyfunctions/soulgraves/database/MySQLDatabase\n*L\n260#1:435\n260#1:436,2\n*E\n"})
public final class MySQLDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private HikariDataSource dataSource;
    @NotNull
    private String jdbcUrl;
    @NotNull
    private String jdbcDriver;
    @NotNull
    private String username;
    @NotNull
    private String password;
    @NotNull
    private final String databaseName;
    @NotNull
    private static final Lazy<MySQLDatabase> instance$delegate = LazyKt.lazy(MySQLDatabase::instance_delegate$lambda$26);

    private MySQLDatabase() {
        this.databaseName = "soul_grave";
        YamlDocument config = DatabaseManager.INSTANCE.getDatabaseConfig();
        String string = config.getString("MySQL.jdbc-url");
        Intrinsics.checkNotNull(string);
        this.jdbcUrl = string;
        String string2 = config.getString("MySQL.jdbc-class");
        Intrinsics.checkNotNull(string2);
        this.jdbcDriver = string2;
        String string3 = config.getString("MySQL.properties.user");
        Intrinsics.checkNotNull(string3);
        this.username = string3;
        String string4 = config.getString("MySQL.properties.password");
        Intrinsics.checkNotNull(string4);
        this.password = string4;
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(this.jdbcUrl);
        hikariConfig.setDriverClassName(this.jdbcDriver);
        hikariConfig.setUsername(this.username);
        hikariConfig.setPassword(this.password);
        this.dataSource = new HikariDataSource(hikariConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createTable() {
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = connection.prepareStatement(StringsKt.trimIndent("\n                CREATE TABLE IF NOT EXISTS " + this.databaseName + " (\n                markerUUID VARCHAR(255) PRIMARY KEY,\n                ownerUUID VARCHAR(255),\n                serverName VARCHAR(255),\n                world VARCHAR(255),\n                x INT,\n                y INT,\n                z INT,\n                inventory TEXT,\n                xp INT,\n                deathTime BIGINT,\n                expireTime BIGINT,\n                freezeTime BIGINT,\n                isDeleted BIT(1) DEFAULT 0)\n                "));
            Throwable throwable2 = null;
            try {
                PreparedStatement statement = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                try {
                    statement.executeUpdate();
                    System.out.println((Object)("Table '" + this.databaseName + "' created successfully."));
                }
                catch (SQLException ex) {
                    System.out.println((Object)("Error while creating table: " + ex.getMessage()));
                    ex.printStackTrace();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initCurrentServerSouls() {
        List souls = new ArrayList();
        CollectionsKt.addAll((Collection)souls, (Iterable)SoulGraves.Companion.getSoulList());
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = connection.prepareStatement(StringsKt.trimIndent("\n                SELECT * FROM " + this.databaseName + " WHERE serverName = ?\n                "));
            Throwable throwable2 = null;
            try {
                PreparedStatement statement = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                statement.setString(1, DatabaseManagerKt.getSERVER_NAME());
                try {
                    ResultSet resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        List<ItemStack> list;
                        UUID uUID;
                        UUID uUID2;
                        Soul.Companion companion = Soul.Companion;
                        Intrinsics.checkNotNullExpressionValue(UUID.fromString(resultSet.getString("markerUUID")), "fromString(...)");
                        Intrinsics.checkNotNullExpressionValue(UUID.fromString(resultSet.getString("ownerUUID")), "fromString(...)");
                        Intrinsics.checkNotNullExpressionValue(ItemTagStream.INSTANCE.listFromBase64(resultSet.getString("inventory")), "listFromBase64(...)");
                        int n = resultSet.getInt("xp");
                        Location location = new Location(Bukkit.getWorld((String)resultSet.getString("world")), resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"));
                        long l = resultSet.getLong("deathTime");
                        long l2 = resultSet.getLong("expireTime");
                        long l3 = resultSet.getLong("freezeTime");
                        Soul soul = companion.initAndStart(uUID2, uUID, location, list, n, l, l2, l3);
                        if (resultSet.getBoolean("isDeleted")) {
                            soul.delete();
                        }
                        if (soul.isValid(true)) {
                            SoulGraves.Companion.getSoulList().add(soul);
                            soul.startTasks();
                            continue;
                        }
                        soul.delete();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveSoul(@NotNull Soul soul) {
        Intrinsics.checkNotNullParameter(soul, "soul");
        long now = System.currentTimeMillis();
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Integer n;
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = connection.prepareStatement(StringsKt.trimIndent("\n            INSERT INTO " + this.databaseName + " \n            (markerUUID, ownerUUID, serverName, world, x, y, z, inventory, xp, deathTime, expireTime, freezeTime, isDeleted) \n            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n            ON DUPLICATE KEY UPDATE\n            ownerUUID = VALUES(ownerUUID),\n            serverName = VALUES(serverName),\n            world = VALUES(world),\n            x = VALUES(x),\n            y = VALUES(y),\n            z = VALUES(z),\n            inventory = VALUES(inventory),\n            xp = VALUES(xp),\n            deathTime = VALUES(deathTime),\n            expireTime = VALUES(expireTime),\n            freezeTime = VALUES(freezeTime),\n            isDeleted = VALUES(isDeleted)\n            "));
            Throwable throwable2 = null;
            try {
                Object object;
                PreparedStatement statement = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                statement.setString(1, soul.getMarkerUUID().toString());
                statement.setString(2, soul.getOwnerUUID().toString());
                statement.setString(3, soul.getServerId());
                World world = soul.getLocation().getWorld();
                statement.setString(4, world != null ? world.getName() : null);
                statement.setInt(5, (int)soul.getLocation().getX());
                statement.setInt(6, (int)soul.getLocation().getY());
                statement.setInt(7, (int)soul.getLocation().getZ());
                statement.setString(8, ItemTagStream.INSTANCE.listToBase64(soul.getInventory()));
                statement.setInt(9, soul.getXp());
                statement.setLong(10, soul.getDeathTime());
                statement.setLong(11, (long)(ConfigManager.INSTANCE.getTimeStable() + ConfigManager.INSTANCE.getTimeUnstable()) * 1000L + now);
                statement.setLong(12, soul.getFreezeTime());
                statement.setBoolean(13, false);
                try {
                    object = statement.executeUpdate();
                }
                catch (SQLException ex) {
                    SoulGraves.Companion.getPlugin().getLogger().severe("Failed to save soul");
                    ex.printStackTrace();
                    object = Unit.INSTANCE;
                }
                n = object;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            Integer n2 = n;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveSoulCopy(@NotNull Soul soul) {
        Intrinsics.checkNotNullParameter(soul, "soul");
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Integer n;
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = connection.prepareStatement(StringsKt.trimIndent("\n            UPDATE " + this.databaseName + " SET \n            ownerUUID = ? ,\n            inventory = ? ,\n            xp = ? ,\n            expireTime = ? ,\n            freezeTime = ?\n            WHERE markerUUID = ?\n            "));
            Throwable throwable2 = null;
            try {
                Object object;
                PreparedStatement statement = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                statement.setString(1, soul.getOwnerUUID().toString());
                statement.setString(2, ItemTagStream.INSTANCE.listToBase64(soul.getInventory()));
                statement.setInt(3, soul.getXp());
                statement.setLong(4, soul.getExpireTime());
                statement.setLong(5, soul.getFreezeTime());
                try {
                    object = statement.executeUpdate();
                }
                catch (SQLException ex) {
                    SoulGraves.Companion.getPlugin().getLogger().severe("Failed to save soul copy");
                    ex.printStackTrace();
                    object = Unit.INSTANCE;
                }
                n = object;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            Integer n2 = n;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Soul> getAllSouls() {
        List souls = new ArrayList();
        CollectionsKt.addAll((Collection)souls, (Iterable)SoulGraves.Companion.getSoulList());
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = connection.prepareStatement(StringsKt.trimIndent("\n                SELECT * FROM " + this.databaseName + "\n                WHERE serverName != ?\n                AND isDeleted = FALSE\n                AND expireTime != 1\n                "));
            Throwable throwable2 = null;
            try {
                PreparedStatement statement = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                statement.setString(1, DatabaseManagerKt.getSERVER_NAME());
                try {
                    ResultSet resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        String string;
                        List<ItemStack> list;
                        UUID uUID;
                        UUID uUID2;
                        long expireTime;
                        long freezeTime = resultSet.getLong("freezeTime");
                        if (freezeTime >= (expireTime = resultSet.getLong("expireTime")) || !ConfigManager.INSTANCE.getOfflineOwnerTimerFreeze() && expireTime <= System.currentTimeMillis()) continue;
                        Soul.Companion companion = Soul.Companion;
                        Intrinsics.checkNotNullExpressionValue(UUID.fromString(resultSet.getString("markerUUID")), "fromString(...)");
                        Intrinsics.checkNotNullExpressionValue(UUID.fromString(resultSet.getString("ownerUUID")), "fromString(...)");
                        Intrinsics.checkNotNullExpressionValue(ItemTagStream.INSTANCE.listFromBase64(resultSet.getString("inventory")), "listFromBase64(...)");
                        int n = resultSet.getInt("xp");
                        Location location = new Location(Bukkit.getWorld((String)resultSet.getString("world")), resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"));
                        Intrinsics.checkNotNullExpressionValue(resultSet.getString("serverName"), "getString(...)");
                        long l = resultSet.getLong("deathTime");
                        souls.add(companion.createDataCopy(uUID2, uUID, location, list, n, string, l, expireTime, freezeTime));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return souls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<Soul> getPlayerSouls(@NotNull UUID playerUUID) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerUUID, "playerUUID");
        List souls = new ArrayList();
        Object object = souls;
        Iterable $this$filter$iv = SoulGraves.Companion.getSoulList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Soul it = (Soul)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getOwnerUUID(), playerUUID)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object2 = (List)destination$iv$iv;
        CollectionsKt.addAll(object, object2);
        object = this.dataSource.getConnection();
        object2 = null;
        try {
            Connection connection = (Connection)object;
            boolean bl = false;
            AutoCloseable autoCloseable = connection.prepareStatement(StringsKt.trimIndent("\n                SELECT * FROM " + this.databaseName + "\n                WHERE ownerUUID = ?\n                AND serverName != ?\n                AND isDeleted = FALSE\n                AND expireTime != 1\n                ORDER BY expireTime ASC\n                "));
            Throwable throwable = null;
            try {
                PreparedStatement statement = (PreparedStatement)autoCloseable;
                boolean bl2 = false;
                statement.setString(1, playerUUID.toString());
                statement.setString(2, DatabaseManagerKt.getSERVER_NAME());
                try {
                    ResultSet resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        String string;
                        List<ItemStack> list;
                        UUID uUID;
                        UUID uUID2;
                        long expireTime;
                        long freezeTime = resultSet.getLong("freezeTime");
                        if (freezeTime >= (expireTime = resultSet.getLong("expireTime")) || !ConfigManager.INSTANCE.getOfflineOwnerTimerFreeze() && expireTime <= System.currentTimeMillis()) continue;
                        Soul.Companion companion = Soul.Companion;
                        Intrinsics.checkNotNullExpressionValue(UUID.fromString(resultSet.getString("markerUUID")), "fromString(...)");
                        Intrinsics.checkNotNullExpressionValue(UUID.fromString(resultSet.getString("ownerUUID")), "fromString(...)");
                        Intrinsics.checkNotNullExpressionValue(ItemTagStream.INSTANCE.listFromBase64(resultSet.getString("inventory")), "listFromBase64(...)");
                        int n = resultSet.getInt("xp");
                        Location location = new Location(Bukkit.getWorld((String)resultSet.getString("world")), resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"));
                        Intrinsics.checkNotNullExpressionValue(resultSet.getString("serverName"), "getString(...)");
                        long l = resultSet.getLong("deathTime");
                        souls.add(companion.createDataCopy(uUID2, uUID, location, list, n, string, l, expireTime, freezeTime));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object2);
        }
        return souls;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Soul getSoul(@NotNull UUID markerUUID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 18[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateSoulFreezeTime(@NotNull UUID makerUUID, long freezeTime, long expireTime) {
        Intrinsics.checkNotNullParameter(makerUUID, "makerUUID");
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Integer n;
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = connection.prepareStatement(StringsKt.trimIndent("\n                UPDATE " + this.databaseName + " SET freezeTime = ?, expireTime = ? WHERE markerUUID = ?\n            "));
            Throwable throwable2 = null;
            try {
                Object object;
                PreparedStatement statement = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                statement.setLong(1, freezeTime);
                statement.setLong(2, expireTime);
                statement.setString(3, makerUUID.toString());
                try {
                    object = statement.executeUpdate();
                }
                catch (SQLException ex) {
                    System.out.println((Object)("Error while update soul delete: " + ex.getMessage()));
                    ex.printStackTrace();
                    object = Unit.INSTANCE;
                }
                n = object;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            Integer n2 = n;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markSoulDelete(@NotNull UUID makerUUID) {
        Intrinsics.checkNotNullParameter(makerUUID, "makerUUID");
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Integer n;
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = connection.prepareStatement(StringsKt.trimIndent("\n                UPDATE " + this.databaseName + " SET isDeleted = 1 WHERE markerUUID = ?\n            "));
            Throwable throwable2 = null;
            try {
                Object object;
                PreparedStatement statement = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                statement.setString(1, makerUUID.toString());
                try {
                    object = statement.executeUpdate();
                }
                catch (SQLException ex) {
                    System.out.println((Object)("Error while mark soul delete: " + ex.getMessage()));
                    ex.printStackTrace();
                    object = Unit.INSTANCE;
                }
                n = object;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            Integer n2 = n;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markSoulExplode(@NotNull UUID makerUUID) {
        Intrinsics.checkNotNullParameter(makerUUID, "makerUUID");
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Integer n;
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = connection.prepareStatement(StringsKt.trimIndent("\n                UPDATE " + this.databaseName + " SET expireTime = 1 WHERE markerUUID = ?\n            "));
            Throwable throwable2 = null;
            try {
                Object object;
                PreparedStatement statement = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                statement.setString(1, makerUUID.toString());
                try {
                    object = statement.executeUpdate();
                }
                catch (SQLException ex) {
                    System.out.println((Object)("Error while mark soul explode: " + ex.getMessage()));
                    ex.printStackTrace();
                    object = Unit.INSTANCE;
                }
                n = object;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            Integer n2 = n;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    public final void deleteSoul(@NotNull Soul soul) {
        Intrinsics.checkNotNullParameter(soul, "soul");
        UUID uuid = soul.getMarkerUUID();
        this.deleteSoul(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteSoul(@NotNull UUID markerUUID) {
        Intrinsics.checkNotNullParameter(markerUUID, "markerUUID");
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Integer n;
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = connection.prepareStatement(StringsKt.trimIndent("\n                DELETE FROM " + this.databaseName + " WHERE markerUUID = ?\n            "));
            Throwable throwable2 = null;
            try {
                Object object;
                PreparedStatement statement = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                statement.setString(1, markerUUID.toString());
                try {
                    object = statement.executeUpdate();
                }
                catch (SQLException ex) {
                    System.out.println((Object)("Error while delete soul: " + ex.getMessage()));
                    ex.printStackTrace();
                    object = Unit.INSTANCE;
                }
                n = object;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            Integer n2 = n;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    private static final boolean getSoul$lambda$13(UUID $markerUUID, Soul it) {
        return Intrinsics.areEqual(it.getMarkerUUID(), $markerUUID);
    }

    private static final boolean getSoul$lambda$14(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final MySQLDatabase instance_delegate$lambda$26() {
        MySQLDatabase mySQLDatabase;
        MySQLDatabase $this$instance_delegate_u24lambda_u2426_u24lambda_u2425 = mySQLDatabase = new MySQLDatabase();
        boolean bl = false;
        $this$instance_delegate_u24lambda_u2426_u24lambda_u2425.createTable();
        $this$instance_delegate_u24lambda_u2426_u24lambda_u2425.initCurrentServerSouls();
        SoulGraves.Companion.getPlugin().getLogger().info("Connected to MySQL Database!");
        return mySQLDatabase;
    }

    @JvmStatic
    @NotNull
    public static final MySQLDatabase getInstanceByJava() {
        return Companion.getInstanceByJava();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0007R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Ldev/faultyfunctions/soulgraves/database/MySQLDatabase$Companion;", "", "<init>", "()V", "instance", "Ldev/faultyfunctions/soulgraves/database/MySQLDatabase;", "getInstance", "()Ldev/faultyfunctions/soulgraves/database/MySQLDatabase;", "instance$delegate", "Lkotlin/Lazy;", "getInstanceByJava", "soulgraves"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MySQLDatabase getInstance() {
            Lazy lazy = instance$delegate;
            return (MySQLDatabase)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final MySQLDatabase getInstanceByJava() {
            return this.getInstance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

