/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.bukkit.actor;

import dev.faultyfunctions.soulgraves.libs.lamp.Lamp;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.SenderNotConsoleException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.SenderNotPlayerException;
import dev.faultyfunctions.soulgraves.libs.lamp.command.CommandActor;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BukkitCommandActor
extends CommandActor {
    @NotNull
    public CommandSender sender();

    default public boolean isPlayer() {
        return this.sender() instanceof Player;
    }

    default public boolean isConsole() {
        return this.sender() instanceof ConsoleCommandSender;
    }

    @Nullable
    default public Player asPlayer() {
        return this.isPlayer() ? (Player)this.sender() : null;
    }

    @NotNull
    default public Player requirePlayer() throws SenderNotPlayerException {
        if (!this.isPlayer()) {
            throw new SenderNotPlayerException();
        }
        return (Player)this.sender();
    }

    @NotNull
    default public ConsoleCommandSender requireConsole() throws SenderNotConsoleException {
        if (!this.isConsole()) {
            throw new SenderNotConsoleException();
        }
        return (ConsoleCommandSender)this.sender();
    }

    @Override
    default public void sendRawMessage(@NotNull String message) {
        this.sender().sendMessage(message);
    }

    @Override
    default public void sendRawError(@NotNull String message) {
        this.sender().sendMessage(ChatColor.RED + message);
    }

    public void reply(@NotNull ComponentLike var1);

    @NotNull
    public Optional<Audience> audience();

    public Lamp<BukkitCommandActor> lamp();

    @Override
    @NotNull
    default public String name() {
        return this.sender().getName();
    }
}

