/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.bukkit.brigadier;

import dev.faultyfunctions.soulgraves.libs.lamp.brigadier.types.ArgumentTypes;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.actor.ActorFactory;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.actor.BukkitCommandActor;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.brigadier.BukkitBrigadierBridge;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.brigadier.ByPaperEvents;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.brigadier.ByPaperLifecycle;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.brigadier.ByReflection;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.util.BukkitVersion;
import dev.faultyfunctions.soulgraves.libs.lamp.command.ExecutableCommand;
import dev.faultyfunctions.soulgraves.libs.lamp.hook.CancelHandle;
import dev.faultyfunctions.soulgraves.libs.lamp.hook.CommandRegisteredHook;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class BrigadierRegistryHook<A extends BukkitCommandActor>
implements CommandRegisteredHook<A> {
    private final ActorFactory<A> actorFactory;
    private final ArgumentTypes<A> argumentTypes;
    private final BukkitBrigadierBridge<A> bridge;
    private final JavaPlugin plugin;

    public BrigadierRegistryHook(ArgumentTypes<A> argumentTypes, ActorFactory<A> actorFactory, JavaPlugin plugin) {
        this.actorFactory = actorFactory;
        this.argumentTypes = argumentTypes;
        this.plugin = plugin;
        this.bridge = this.createBridge();
    }

    private BukkitBrigadierBridge<A> createBridge() {
        if (BukkitVersion.isPaper()) {
            if (BukkitVersion.supports(1, 20, 6)) {
                return new ByPaperLifecycle<A>(this.plugin, this.argumentTypes, this.actorFactory);
            }
            if (BukkitVersion.supports(1, 19)) {
                return new ByPaperEvents<A>(this.plugin, this.argumentTypes, this.actorFactory);
            }
        }
        return new ByReflection<A>(this.plugin, this.argumentTypes, this.actorFactory);
    }

    @Override
    public void onRegistered(@NotNull ExecutableCommand<A> command, @NotNull CancelHandle cancelHandle) {
        this.bridge.register(command);
    }
}

