/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception;

import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.actor.BukkitCommandActor;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.EmptyEntitySelectorException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.InvalidPlayerException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.InvalidWorldException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.MalformedEntitySelectorException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.MissingLocationParameterException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.MoreThanOneEntityException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.NonPlayerEntitiesException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.SenderNotConsoleException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.SenderNotPlayerException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.util.BukkitUtils;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.DefaultExceptionHandler;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.EnumNotFoundException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.ExpectedLiteralException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.InputParseException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.InvalidBooleanException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.InvalidDecimalException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.InvalidHelpPageException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.InvalidIntegerException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.InvalidListSizeException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.InvalidStringSizeException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.InvalidUUIDException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.MissingArgumentException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.NoPermissionException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.NumberNotInRangeException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.RuntimeExceptionAdapter;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.UnknownCommandException;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.ValueNotAllowedException;
import dev.faultyfunctions.soulgraves.libs.lamp.node.ParameterNode;
import org.jetbrains.annotations.NotNull;

public class BukkitExceptionHandler
extends DefaultExceptionHandler<BukkitCommandActor> {
    @RuntimeExceptionAdapter.HandleException
    public void onInvalidPlayer(InvalidPlayerException e, BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cInvalid player: &e" + e.input() + "&c."));
    }

    @RuntimeExceptionAdapter.HandleException
    public void onInvalidWorld(InvalidWorldException e, BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cInvalid world: &e" + e.input() + "&c."));
    }

    @RuntimeExceptionAdapter.HandleException
    public void onInvalidWorld(MissingLocationParameterException e, BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cExpected &e" + e.axis().name().toLowerCase() + "&c."));
    }

    @RuntimeExceptionAdapter.HandleException
    public void onSenderNotConsole(SenderNotConsoleException e, BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cYou must be the console to execute this command!"));
    }

    @RuntimeExceptionAdapter.HandleException
    public void onSenderNotPlayer(SenderNotPlayerException e, BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cYou must be a player to execute this command!"));
    }

    @RuntimeExceptionAdapter.HandleException
    public void onMalformedEntitySelector(MalformedEntitySelectorException e, BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cMalformed entity selector: &e" + e.input() + "&c. Error: &e" + e.errorMessage()));
    }

    @RuntimeExceptionAdapter.HandleException
    public void onNonPlayerEntities(NonPlayerEntitiesException e, BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cYour entity selector (&e" + e.input() + "&c) only allows players, but it contains non-player entities too."));
    }

    @RuntimeExceptionAdapter.HandleException
    public void onMoreThanOneEntity(MoreThanOneEntityException e, BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cOnly one entity is allowed, but the provided selector allows more than one"));
    }

    @RuntimeExceptionAdapter.HandleException
    public void onEmptyEntitySelector(EmptyEntitySelectorException e, BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cNo entities were found."));
    }

    @Override
    public void onEnumNotFound(@NotNull EnumNotFoundException e, @NotNull BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cInvalid choice: &e" + e.input() + "&c. Please enter a valid option from the available values."));
    }

    @Override
    public void onExpectedLiteral(@NotNull ExpectedLiteralException e, @NotNull BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cExpected &e" + e.node().name() + "&c, found &e" + e.input() + "&c."));
    }

    @Override
    public void onInputParse(@NotNull InputParseException e, @NotNull BukkitCommandActor actor) {
        switch (e.cause()) {
            case INVALID_ESCAPE_CHARACTER: {
                actor.error(BukkitUtils.legacyColorize("&cInvalid input. Use &e\\\\ &cto include a backslash."));
                break;
            }
            case UNCLOSED_QUOTE: {
                actor.error(BukkitUtils.legacyColorize("&cUnclosed quote. Make sure to close all quotes."));
                break;
            }
            case EXPECTED_WHITESPACE: {
                actor.error(BukkitUtils.legacyColorize("&cExpected whitespace to end one argument, but found trailing data."));
            }
        }
    }

    @Override
    public void onInvalidListSize(@NotNull InvalidListSizeException e, @NotNull BukkitCommandActor actor, @NotNull ParameterNode<BukkitCommandActor, ?> parameter) {
        if (e.inputSize() < e.minimum()) {
            actor.error(BukkitUtils.legacyColorize("&cYou must input at least &e" + BukkitExceptionHandler.fmt(e.minimum()) + " &centries for &e" + parameter.name() + "&c."));
        }
        if (e.inputSize() > e.maximum()) {
            actor.error(BukkitUtils.legacyColorize("&cYou must input at most &e" + BukkitExceptionHandler.fmt(e.maximum()) + " &centries for &e" + parameter.name() + "&c."));
        }
    }

    @Override
    public void onInvalidStringSize(@NotNull InvalidStringSizeException e, @NotNull BukkitCommandActor actor, @NotNull ParameterNode<BukkitCommandActor, ?> parameter) {
        if (e.input().length() < e.minimum()) {
            actor.error(BukkitUtils.legacyColorize("&cParameter &e" + parameter.name() + " &cmust be at least &e" + BukkitExceptionHandler.fmt(e.minimum()) + " &ccharacters long."));
        }
        if (e.input().length() > e.maximum()) {
            actor.error(BukkitUtils.legacyColorize("&cParameter &e" + parameter.name() + " &ccan be at most &e" + BukkitExceptionHandler.fmt(e.maximum()) + " &ccharacters long."));
        }
    }

    @Override
    public void onInvalidBoolean(@NotNull InvalidBooleanException e, @NotNull BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cExpected &etrue &cor &efalse&c, found &e" + e.input() + "&c."));
    }

    @Override
    public void onInvalidDecimal(@NotNull InvalidDecimalException e, @NotNull BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cInvalid number: &e" + e.input() + "&c."));
    }

    @Override
    public void onInvalidInteger(@NotNull InvalidIntegerException e, @NotNull BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cInvalid integer: &e" + e.input() + "&c."));
    }

    @Override
    public void onInvalidUUID(@NotNull InvalidUUIDException e, @NotNull BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cInvalid UUID: " + e.input() + "&c."));
    }

    @Override
    public void onMissingArgument(@NotNull MissingArgumentException e, @NotNull BukkitCommandActor actor, @NotNull ParameterNode<BukkitCommandActor, ?> parameter) {
        actor.error(BukkitUtils.legacyColorize("&cRequired parameter is missing: &e" + parameter.name() + "&c. Usage: &e/" + parameter.command().usage() + "&c."));
    }

    @Override
    public void onNoPermission(@NotNull NoPermissionException e, @NotNull BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cYou do not have permission to execute this command!"));
    }

    @Override
    public void onNumberNotInRange(@NotNull NumberNotInRangeException e, @NotNull BukkitCommandActor actor, @NotNull ParameterNode<BukkitCommandActor, Number> parameter) {
        if (e.input().doubleValue() < e.minimum()) {
            actor.error(BukkitUtils.legacyColorize("&c" + parameter.name() + " too small &e(" + BukkitExceptionHandler.fmt(e.input()) + ")&c. Must be at least &e" + BukkitExceptionHandler.fmt(e.minimum()) + "&c."));
        }
        if (e.input().doubleValue() > e.maximum()) {
            actor.error(BukkitUtils.legacyColorize("&c" + parameter.name() + " too large &e(" + BukkitExceptionHandler.fmt(e.input()) + ")&c. Must be at most &e" + BukkitExceptionHandler.fmt(e.maximum()) + "&c."));
        }
    }

    @Override
    public void onInvalidHelpPage(@NotNull InvalidHelpPageException e, @NotNull BukkitCommandActor actor) {
        if (e.numberOfPages() == 1) {
            actor.error(BukkitUtils.legacyColorize("Invalid help page: &e" + e.page() + "&c. Must be 1."));
        } else {
            actor.error(BukkitUtils.legacyColorize("Invalid help page: &e" + e.page() + "&c. Must be between &e1 &cand &e" + e.numberOfPages()));
        }
    }

    @Override
    public void onUnknownCommand(@NotNull UnknownCommandException e, @NotNull BukkitCommandActor actor) {
        actor.error(BukkitUtils.legacyColorize("&cUnknown command: &e" + e.input() + "&c."));
    }

    @Override
    public void onValueNotAllowed(@NotNull ValueNotAllowedException e, @NotNull BukkitCommandActor actor) {
        String allowedValues = String.join((CharSequence)"&c, &e", e.allowedValues());
        actor.error(BukkitUtils.legacyColorize("Received an invalid value: &e" + e.input() + "&c. Allowed values: &e" + allowedValues + "&c."));
    }
}

