/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.bukkit.hooks;

import dev.faultyfunctions.soulgraves.libs.lamp.Lamp;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.actor.ActorFactory;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.actor.BukkitCommandActor;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.util.BukkitUtils;
import dev.faultyfunctions.soulgraves.libs.lamp.stream.MutableStringStream;
import dev.faultyfunctions.soulgraves.libs.lamp.stream.StringStream;
import dev.faultyfunctions.soulgraves.libs.lamp.util.Collections;
import dev.faultyfunctions.soulgraves.libs.lamp.util.Strings;
import java.util.List;
import java.util.StringJoiner;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;

public final class LampCommandExecutor<A extends BukkitCommandActor>
implements TabExecutor {
    @NotNull
    private final Lamp<A> lamp;
    @NotNull
    private final ActorFactory<A> actorFactory;

    public LampCommandExecutor(@NotNull Lamp<A> lamp, @NotNull ActorFactory<A> actorFactory) {
        this.lamp = lamp;
        this.actorFactory = actorFactory;
    }

    private static String ignoreAfterSpace(String v) {
        int spaceIndex = v.indexOf(32);
        return spaceIndex == -1 ? v : v.substring(0, spaceIndex);
    }

    @NotNull
    private static MutableStringStream createInput(String commandName, String[] args2) {
        StringJoiner userInput = new StringJoiner(" ");
        userInput.add(Strings.stripNamespace(commandName));
        for (String arg : args2) {
            userInput.add(arg);
        }
        return StringStream.createMutable(userInput.toString());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args2) {
        A actor = this.actorFactory.create(sender, this.lamp);
        MutableStringStream input = LampCommandExecutor.createInput(command.getName(), args2);
        this.lamp.dispatch(actor, input);
        return true;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args2) {
        A actor = this.actorFactory.create(sender, this.lamp);
        MutableStringStream input = LampCommandExecutor.createInput(command.getName(), args2);
        List<String> completions = this.lamp.autoCompleter().complete(actor, input);
        if (BukkitUtils.isBrigadierAvailable()) {
            return completions;
        }
        return Collections.map(completions, LampCommandExecutor::ignoreAfterSpace);
    }
}

