/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.bukkit.parameters;

import dev.faultyfunctions.soulgraves.libs.lamp.autocomplete.SuggestionProvider;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.actor.BukkitCommandActor;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.EmptyEntitySelectorException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.MalformedEntitySelectorException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.MoreThanOneEntityException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.util.BukkitVersion;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.CommandErrorException;
import dev.faultyfunctions.soulgraves.libs.lamp.node.ExecutionContext;
import dev.faultyfunctions.soulgraves.libs.lamp.parameter.ParameterType;
import dev.faultyfunctions.soulgraves.libs.lamp.stream.MutableStringStream;
import dev.faultyfunctions.soulgraves.libs.lamp.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

public final class EntityParameterType
implements ParameterType<BukkitCommandActor, Entity> {
    @NotNull
    private static Entity fromSelector(@NotNull CommandSender sender, @NotNull String selector) {
        try {
            List entityList = Bukkit.selectEntities((CommandSender)sender, (String)selector);
            if (entityList.isEmpty()) {
                throw new EmptyEntitySelectorException(selector);
            }
            if (entityList.size() != 1) {
                throw new MoreThanOneEntityException(selector);
            }
            return (Entity)entityList.get(0);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedEntitySelectorException(selector, e.getCause().getMessage());
        }
        catch (NoSuchMethodError e) {
            throw new CommandErrorException("Entity selectors on legacy versions are not supported yet!", new Object[0]);
        }
    }

    @Override
    public Entity parse(@NotNull MutableStringStream input, @NotNull ExecutionContext<BukkitCommandActor> context) {
        String value = input.readString();
        return EntityParameterType.fromSelector(context.actor().sender(), value);
    }

    @Override
    @NotNull
    public SuggestionProvider<BukkitCommandActor> defaultSuggestions() {
        if (BukkitVersion.isBrigadierSupported()) {
            return SuggestionProvider.empty();
        }
        return context -> Collections.map(Bukkit.getOnlinePlayers(), OfflinePlayer::getName);
    }
}

