/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.bukkit.parameters;

import com.google.common.collect.ForwardingList;
import dev.faultyfunctions.soulgraves.libs.lamp.Lamp;
import dev.faultyfunctions.soulgraves.libs.lamp.annotation.list.AnnotationList;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.actor.BukkitCommandActor;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.EmptyEntitySelectorException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.MalformedEntitySelectorException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.parameters.EntitySelector;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.CommandErrorException;
import dev.faultyfunctions.soulgraves.libs.lamp.node.ExecutionContext;
import dev.faultyfunctions.soulgraves.libs.lamp.parameter.ParameterType;
import dev.faultyfunctions.soulgraves.libs.lamp.stream.MutableStringStream;
import dev.faultyfunctions.soulgraves.libs.lamp.util.Classes;
import dev.faultyfunctions.soulgraves.libs.lamp.util.Preconditions;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntitySelectorParameterTypeFactory
implements ParameterType.Factory<BukkitCommandActor> {
    @Override
    @Nullable
    public <T> ParameterType<BukkitCommandActor, T> create(@NotNull Type parameterType, @NotNull AnnotationList annotations, @NotNull Lamp<BukkitCommandActor> lamp) {
        Class<?> rawType = Classes.getRawType(parameterType);
        if (rawType != EntitySelector.class) {
            return null;
        }
        Class<Entity> entityClass = Classes.getRawType(Classes.getFirstGeneric(parameterType, Entity.class)).asSubclass(Entity.class);
        return new EntitySelectorParameterType(entityClass);
    }

    static final class SelectorList<E extends Entity>
    extends ForwardingList<E>
    implements EntitySelector<E> {
        private final List<E> entities;

        public SelectorList(List<E> entities) {
            this.entities = Preconditions.notNull(entities, "entities list");
        }

        protected List<E> delegate() {
            return this.entities;
        }
    }

    static final class EntitySelectorParameterType
    implements ParameterType<BukkitCommandActor, EntitySelector<?>> {
        private final Class<?> entityType;

        public EntitySelectorParameterType(Class<?> entityType) {
            this.entityType = entityType;
        }

        @Override
        public EntitySelector<?> parse(@NotNull MutableStringStream input, @NotNull ExecutionContext<BukkitCommandActor> context) {
            String selector = input.readString();
            try {
                ArrayList<Entity> c = new ArrayList<Entity>(Bukkit.getServer().selectEntities(context.actor().sender(), selector));
                c.removeIf(obj -> !this.entityType.isInstance(obj));
                if (c.isEmpty()) {
                    throw new EmptyEntitySelectorException(selector);
                }
                return new SelectorList(c);
            }
            catch (IllegalArgumentException e) {
                throw new MalformedEntitySelectorException(selector, e.getCause().getMessage());
            }
            catch (NoSuchMethodError e) {
                throw new CommandErrorException("Entity selectors on legacy versions are not supported yet!", new Object[0]);
            }
        }
    }
}

