/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.bukkit.parameters;

import dev.faultyfunctions.soulgraves.libs.lamp.autocomplete.SuggestionProvider;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.actor.BukkitCommandActor;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.exception.InvalidPlayerException;
import dev.faultyfunctions.soulgraves.libs.lamp.bukkit.util.BukkitVersion;
import dev.faultyfunctions.soulgraves.libs.lamp.node.ExecutionContext;
import dev.faultyfunctions.soulgraves.libs.lamp.parameter.ParameterType;
import dev.faultyfunctions.soulgraves.libs.lamp.stream.MutableStringStream;
import dev.faultyfunctions.soulgraves.libs.lamp.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public final class OfflinePlayerParameterType
implements ParameterType<BukkitCommandActor, OfflinePlayer> {
    private final boolean brigadierEnabled;

    public OfflinePlayerParameterType(boolean brigadierEnabled) {
        this.brigadierEnabled = brigadierEnabled;
    }

    private static boolean exists(OfflinePlayer player) {
        return player.hasPlayedBefore() || player.isOnline() || player.getFirstPlayed() != 0L;
    }

    @Override
    public OfflinePlayer parse(@NotNull MutableStringStream input, @NotNull ExecutionContext<BukkitCommandActor> context) {
        String name = input.readString();
        if (name.equals("self") || name.equals("me") || name.equals("@s")) {
            return context.actor().requirePlayer();
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)name);
        if (OfflinePlayerParameterType.exists(player)) {
            return player;
        }
        throw new InvalidPlayerException(name);
    }

    @Override
    @NotNull
    public SuggestionProvider<BukkitCommandActor> defaultSuggestions() {
        if (BukkitVersion.isBrigadierSupported() && this.brigadierEnabled) {
            return SuggestionProvider.empty();
        }
        return context -> Collections.map(Bukkit.getOnlinePlayers(), OfflinePlayer::getName);
    }
}

