/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.node;

import dev.faultyfunctions.soulgraves.libs.lamp.util.BuiltInNamingStrategies;
import java.lang.reflect.Parameter;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ParameterNamingStrategy {
    public static ParameterNamingStrategy identity() {
        return Parameter::getName;
    }

    public static ParameterNamingStrategy lowerCaseWithSeparator(String separator) {
        return parameter -> BuiltInNamingStrategies.separateCamelCase(parameter.getName(), separator).toLowerCase(Locale.ENGLISH);
    }

    public static ParameterNamingStrategy lowerCaseWithSpace() {
        return ParameterNamingStrategy.lowerCaseWithSeparator(" ");
    }

    public static ParameterNamingStrategy upperCamelCase() {
        return parameter -> BuiltInNamingStrategies.upperCaseFirstLetter(parameter.getName());
    }

    public static ParameterNamingStrategy upperCamelCaseWithSpace() {
        return ParameterNamingStrategy.upperCamelCaseWithSeparator(" ");
    }

    public static ParameterNamingStrategy upperCamelCaseWithSeparator(String separator) {
        return parameter -> BuiltInNamingStrategies.upperCaseFirstLetter(BuiltInNamingStrategies.separateCamelCase(parameter.getName(), separator));
    }

    @NotNull
    public String getName(@NotNull Parameter var1);
}

