/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.node.parser;

import dev.faultyfunctions.soulgraves.libs.lamp.autocomplete.SuggestionProvider;
import dev.faultyfunctions.soulgraves.libs.lamp.command.CommandActor;
import dev.faultyfunctions.soulgraves.libs.lamp.command.CommandParameter;
import dev.faultyfunctions.soulgraves.libs.lamp.command.CommandPermission;
import dev.faultyfunctions.soulgraves.libs.lamp.node.CommandNode;
import dev.faultyfunctions.soulgraves.libs.lamp.node.ParameterNode;
import dev.faultyfunctions.soulgraves.libs.lamp.node.parser.MutableCommandNode;
import dev.faultyfunctions.soulgraves.libs.lamp.node.parser.ParameterNodeImpl;
import dev.faultyfunctions.soulgraves.libs.lamp.parameter.ParameterType;
import org.jetbrains.annotations.NotNull;

final class MutableParameterNode<A extends CommandActor, T>
extends MutableCommandNode<A>
implements Comparable<MutableParameterNode<A, Object>> {
    @NotNull
    private ParameterType<A, T> type;
    @NotNull
    private SuggestionProvider<A> suggestions = SuggestionProvider.empty();
    @NotNull
    private CommandPermission<A> permission = CommandPermission.alwaysTrue();
    @NotNull
    private CommandParameter parameter;
    private boolean isOptional;

    public MutableParameterNode(@NotNull String name) {
        super(name);
    }

    @Override
    public int compareTo(@NotNull MutableParameterNode<A, Object> o) {
        return this.type.parsePriority().comparator().compare(this.type(), o.type());
    }

    @NotNull
    public ParameterNode<A, T> createNode() {
        return new ParameterNodeImpl(this.getName(), this.getAction(), this.isLast(), this.type, this.suggestions, this.parameter, this.permission, this.isOptional);
    }

    public void setType(@NotNull ParameterType<A, T> type) {
        this.type = type;
        if (this.suggestions == SuggestionProvider.empty()) {
            this.suggestions = type.defaultSuggestions();
        }
    }

    @Override
    public CommandNode<A> toNode() {
        return this.createNode();
    }

    @NotNull
    public ParameterType<A, T> type() {
        return this.type;
    }

    @NotNull
    public SuggestionProvider<A> suggestions() {
        return this.suggestions;
    }

    @NotNull
    public CommandParameter parameter() {
        return this.parameter;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public void setSuggestions(@NotNull SuggestionProvider<A> suggestions) {
        if (suggestions == null) {
            throw new NullPointerException("suggestions is marked non-null but is null");
        }
        this.suggestions = suggestions;
    }

    public void setPermission(@NotNull CommandPermission<A> permission) {
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        this.permission = permission;
    }

    public void setParameter(@NotNull CommandParameter parameter) {
        if (parameter == null) {
            throw new NullPointerException("parameter is marked non-null but is null");
        }
        this.parameter = parameter;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }
}

