/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.soulgraves.libs.lamp.parameter;

import dev.faultyfunctions.soulgraves.libs.lamp.Lamp;
import dev.faultyfunctions.soulgraves.libs.lamp.annotation.Length;
import dev.faultyfunctions.soulgraves.libs.lamp.command.CommandActor;
import dev.faultyfunctions.soulgraves.libs.lamp.exception.InvalidStringSizeException;
import dev.faultyfunctions.soulgraves.libs.lamp.node.ParameterNode;
import dev.faultyfunctions.soulgraves.libs.lamp.process.ParameterValidator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public enum LengthChecker implements ParameterValidator<CommandActor, String>
{
    INSTANCE;


    @Override
    public void validate(@NotNull CommandActor actor, String value, @NotNull ParameterNode<CommandActor, String> parameter, @NotNull Lamp<CommandActor> lamp) {
        Length range = parameter.annotations().get(Length.class);
        if (range == null) {
            return;
        }
        if (value.length() > range.max() || value.length() < range.min()) {
            throw new InvalidStringSizeException(range.min(), range.max(), value);
        }
    }
}

